% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveMerger.R
\name{moveMerger}
\alias{moveMerger}
\title{Move Merger}
\usage{
moveMerger(
  events,
  small_track_action = "merge",
  max_locs = 1,
  max_time = 600,
  max_dist = 100
)
}
\arguments{
\item{events}{data.table of events from \code{\link{returnStateEvents}}}

\item{small_track_action}{One of "merge" or "exclude" for specifying the
method of handling mergeable tracks}

\item{max_locs}{Maximum number of locations for a track to be mergeable. Set
to Inf to not consider.}

\item{max_time}{Maximum time elapsed (seconds) for a track to be mergeable.
Set to Inf to not consider.}

\item{max_dist}{Maximum distance (meters) traveled while on track to be
mergeable. Set to Inf to not consider.}
}
\value{
Modifies events data.table by reference
}
\description{
Handles move/track events that do not meet specific thresholds to be
considered. This is based on the researcher-decided total number of
allowable locations that the discarded track can consist of, as well as a
maximum total time length that may elapse. Tracks can be merged into the
preceding stop or excluded. Future versions of this should consider assigning
to the closest stop for \code{small_track_action = merge}.
}
