% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twometrics_graph.R
\name{twometrics_graph}
\alias{twometrics_graph}
\title{Graph One Performance Metric vs. Another for Various Investments}
\usage{
twometrics_graph(tickers = NULL, ..., gains = NULL, prices = NULL,
  x.metric = "mdd", y.metric = "cagr", tickerlabel.offsets = NULL,
  add.plot = FALSE, colors = NULL, plot.list = NULL, points.list = NULL,
  text.list = NULL, pdf.list = NULL, bmp.list = NULL, jpeg.list = NULL,
  png.list = NULL, tiff.list = NULL)
}
\arguments{
\item{tickers}{Character vector of ticker symbols that Yahoo! Finance 
recognizes, if you want to download data on the fly.}

\item{...}{Arguments to pass along with \code{tickers} to 
\code{\link{load_gains}}.}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{x.metric}{Character string specifying x-axis performance metric. 
Choices are:

\code{"mean"} or \code{"sd"} for mean or standard deviation of gains.

\code{"growth"} or \code{"cagr"} for total or annualized growth.

\code{"mdd"} for maximum drawdown.

\code{"sharpe"} or \code{"sortino"} for Sharpe or Sortino ratio.

\code{"alpha"}, \code{"beta"}, or \code{"r.squared"} for those metrics from a 
fitted linear regression on benchmark fund.

\code{"pearson"} or \code{"spearman"} for Pearson or Spearman correlation 
with benchmark fund.

\code{"alpha2"}, \code{"beta2"}, \code{"r.squared2"}, \code{"pearson2"}, or 
\code{"spearman2"} for same as previously described, but using the second 
benchmark index.

\code{"auto.pearson"} or \code{"auto.spearman"} for Pearson or Spearman 
autocorrelation, defined as the correlation between subsequent gains.}

\item{y.metric}{Same as \code{x.metric}, but for the y-axis.}

\item{tickerlabel.offsets}{Either a numeric vector of length 2 giving the 
x- and y-axis offsets for all ticker labels, or a 2-column matrix where each 
row gives the x- and y-axis offsets for a ticker.}

\item{add.plot}{Logical value for whether to add plot data to current plot 
frame rather than open a new one.}

\item{colors}{Character vector of colors for each curve.}

\item{plot.list}{List of arguments to pass to \code{\link[graphics]{plot}}.}

\item{points.list}{List of arguments to pass to 
\code{\link[graphics]{points}}.}

\item{text.list}{List of arguments to pass to \code{\link[graphics]{text}}.}

\item{pdf.list}{List of arguments to pass to \code{\link[grDevices]{pdf}}.}

\item{bmp.list}{List of arguments to pass to \code{\link[grDevices]{bmp}}.}

\item{jpeg.list}{List of arguments to pass to \code{\link[grDevices]{jpeg}}.}

\item{png.list}{List of arguments to pass to \code{\link[grDevices]{png}}.}

\item{tiff.list}{List of arguments to pass to \code{\link[grDevices]{tiff}}.}
}
\value{
In addition to the graph, a data frame containing the performance metrics for 
each investment.
}
\description{
Useful for visualizing the performance of a group of investments. The first 
investment is used as the benchmark if \code{x.metric} or \code{y.metric} 
require one benchmark, and the first two investments are used as benchmarks 
if \code{x.metric} and \code{y.metric} require different benchmarks.
}
\examples{
\dontrun{
# Plot annualized growth vs. maximum drawdown for VFINX, SSO, and UPRO
fig <- twometrics_graph(tickers = c("VFINX", "SSO", "UPRO"))
}

}
\references{
Ryan, J.A. and Ulrich, J.M. (2017) quantmod: Quantitative Financial Modelling 
Framework. R package version 0.4-12, 
\url{https://CRAN.R-project.org/package=quantmod}.
}
