% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ratios}
\alias{ratios}
\title{Ratios of Subsequent Elements in a Vector}
\usage{
ratios(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Numeric vector.
}
\description{
Calculates vector of ratios of a vector, i.e. ratio of \code{x[2]} to 
\code{x[1]}, ratio of \code{x[3]} to \code{x[2]}, and so forth.
}
\examples{
# Generate 10 values from N(0, 1)
x <- rnorm(10)

# Calculate vector of ratios
(y <- ratios(x))

# Slower base R computation
len <- length(x)
y2 <- x[2: len] / x[1: (len - 1)]
all.equal(y, y2)


}
