% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{map_quiz}
\alias{map_quiz}
\title{Map Quiz Wrong Guesses Across Five Intro to IR Courses}
\format{
A data frame with 1772 observations on the following 8 variables.
\describe{
\item{\code{class}}{an ordered factor of the semester in which the wrong
guess was recorded by a student. Levels include "Spring 2018", "Fall 2018",
"Spring 2019", "Fall 2019", and "Spring 2020."}
\item{\code{students}}{the number of students in the class taking the
map quiz.}
\item{\code{region}}{the region map on which the country was located.
Values include "Europe", "Africa", "Asia", "Latin America", and "MENA."
"MENA" is short for "Middle East and North Africa."}
\item{\code{country}}{the country I asked the student to correctly
identify}
\item{\code{guess}}{the country that was the actual state incorrectly
guessed by the student}
\item{\code{ccode1}}{the Correlates of War state code for
the state I wanted the student to identify in \code{country}.}
\item{\code{ccode2}}{the Correlates of War state code for the
state that is the wrong guess for the state in \code{guess}}
\item{\code{mindist}}{the minimum distance (in kilometers) between
\code{country} and \code{guess}}}
}
\usage{
map_quiz
}
\description{
This is a simple data set that records every wrong guess for map quiz
assignments I gave in my intro to IR class at Clemson University across
five semesters.
}
\details{
Students can always not make a guess and be wrong, which explains the
\code{NA}s in the data. Students were given five
separate numbered maps and prompted to identify 10 countries each on
them. The maps never changed across five semesters, nor did the prompts.
Use these data as you see fit. Obviously, FERPA considerations mean I
can't share anything else of potential value here.
}
\keyword{datasets}
