context("util (tar)")


test_that("tar_directory", {
  skip_if_external_tar_unsupported()
  p <- tempfile_test()
  dir.create(p, TRUE, FALSE)
  for (i in letters) {
    writeLines(i, file.path(p, i))
  }

  bin <- tar_directory(p)
  expect_is(bin, "raw")
  tmp <- untar_bin(bin)
  expect_true(setequal(dir(tmp), letters))

  unlink(tmp, recursive = TRUE)
  unlink(p, recursive = TRUE)
})


test_that("selective tar", {
  skip_if_external_tar_unsupported()
  p <- tempfile_test()
  dir.create(p, TRUE, FALSE)

  for (i in letters) {
    writeLines(i, file.path(p, i))
  }

  bin <- tar_files(letters[1:6], p)

  tmp <- untar_bin(bin)
  expect_true(setequal(dir(tmp), letters[1:6]))

  unlink(tmp, recursive = TRUE)
  unlink(p, recursive = TRUE)
})


test_that("tar_file", {
  skip_if_external_tar_unsupported()
  bin <- tar_file("sample_responses/README.md")
  tmp <- untar_bin(bin)
  expect_equal(dir(tmp), "README.md")
  expect_equal(unname(tools::md5sum(file.path(tmp, "README.md"))),
               unname(tools::md5sum("sample_responses/README.md")))
  unlink(tmp, recursive = TRUE)
})


test_that("tar failure", {
  skip_if_external_tar_unsupported()
  p1 <- tempfile_test()
  p2 <- tempfile_test()
  expect_error(tar_system(p1, p2),
               "tar failed with status")
  unlink(p1)
})


test_that("external list", {
  skip_if_external_tar_unsupported()
  p <- tempfile_test()
  dir.create(p, TRUE, FALSE)
  for (i in letters) {
    writeLines(i, file.path(p, i))
  }

  bin <- tar_files(letters[1:6], p, external_list = TRUE)
  tmp <- untar_bin(bin)
  expect_true(setequal(dir(tmp), letters[1:6]))

  unlink(tmp, recursive = TRUE)
  unlink(p, recursive = TRUE)
})
