% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{SimData}
\alias{SimData}
\title{Simulate data with normally distributed predictors and binary response}
\usage{
SimData(N, beta, noise, corr = TRUE, corr.effect = 0.5)
}
\arguments{
\item{N}{sample size}

\item{beta}{coefficients (effect of informative predictors)}

\item{noise}{variables (effect of uninformative predictors)}

\item{corr}{Logical, if FALSE the function generates uncorrelated predictors,
if TRUE  the correlation between predictors is 0.5 by default and the user can supply a different value in
the corr.effect argument.}

\item{corr.effect}{the correlation between informative predictors.}
}
\value{
A data frame N x p, where p is the total number of informative and uninformative predictors.
The first column of the dataframe is the binary response variable y
}
\description{
Simulate data with normally distributed predictors and binary response
}
\details{
The response y follows a Binomial distribution with probability= exp(X*beta)/(1+exp(X*beta))
}
\examples{
# simulate data with N=100 (sample size) and 23 predictors; 4 informative and 20 noise

set.seed(14)
beta    <- c(3, 2, -1.6, -4)
noise <- 5
N     <- 100
simData <- SimData(N=N, beta=beta, noise=noise, corr=FALSE)

}

