% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.median.ws}
\alias{ci.2x2.median.ws}
\title{Computes confidence intervals of effects in a 2x2 within-subjects design
for medians}
\usage{
ci.2x2.median.ws(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A and level 1 of B}

\item{y12}{vector of scores at level 1 of A and level 2 of B}

\item{y21}{vector of scores at level 2 of A and level 1 of B}

\item{y22}{vector of scores at level 2 of A and level 2 of B}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimate of effect
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes distribution-free confidence intervals for the AB interaction
effect, main effect of A, main effect of B, simple main effects of A, and
simple main effects of B in a 2x2 within-subjects design. The effects are
defined in terms of medians rather than means. Tied scores within each
level combination are assumed to be rare.
}
\examples{
y11 <- c(222, 402, 333, 301, 284, 182, 281, 230, 290, 182, 133, 278)
y12 <- c(221, 371, 340, 288, 293, 150, 317, 211, 286, 161, 126, 234)
y21 <- c(219, 371, 314, 279, 284, 155, 278, 185, 296, 169, 118, 229)
y22 <- c(170, 332, 280, 273, 272, 160, 260, 204, 252, 153, 137, 223)
ci.2x2.median.ws(.05, y11, y12, y21, y22)

# Should return:
#          Estimate        SE           LL       UL
# AB:          3.50 21.050122 -37.75748155 44.75748
# A:          24.25  9.603490   5.42750463 43.07250
# B:          17.75  9.101881  -0.08935904 35.58936
# A at b1:    26.00 11.813742   2.84549058 49.15451
# A at b2:    22.50 16.323093  -9.49267494 54.49267
# B at a1:    19.50 15.710347 -11.29171468 50.29171
# B at a2:    16.00 11.850202  -7.22596953 39.22597


}
\references{
\insertRef{Bonett2020}{statpsych}
}
