% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.spear}
\alias{size.ci.spear}
\title{Sample size for a Spearman correlation confidence interval}
\usage{
size.ci.spear(alpha, cor, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{planning value of Spearman correlation}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population Spearman correlation
with desired confidence interval precision. Set the correlation planning value
to the smallest absolute value within a plausible range for a conservatively
large sample size.
}
\examples{
size.ci.spear(.05, .362, .25)

# Should return:
# Sample size
#         200
 

}
\references{
\insertRef{Bonett2000}{statpsych}
}
