% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.slope.prop.bs}
\alias{ci.slope.prop.bs}
\title{Confidence interval for a slope of a proportion in a single-factor design
with a quantitative between-subjects factor}
\usage{
ci.slope.prop.bs(alpha, f, n, x)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}

\item{x}{vector of quantitative factor values}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted slope estimate
\item SE - adjusted standard error
\item z - z test statistic
\item p - p-value
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes a test statistic and an adjusted Wald confidence interval for the
slope of proportions in a single-factor design with a quantitative
between-subjects factor.
}
\examples{
f <- c(14, 27, 38)
n <- c(100, 100, 100)
x <- c(10, 20, 40)
ci.slope.prop.bs(.05, f, n, x)

# Should return:
#    Estimate          SE        z           p          LL         UL
# 0.007542293 0.002016793 3.739746 0.000184206 0.003589452 0.01149513


}
\references{
\insertRef{Price2004}{statpsych}
}
