% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cor}
\alias{ci.cor}
\title{Confidence interval for a Pearson or partial correlation}
\usage{
ci.cor(alpha, cor, s, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{estimated Pearson or partial correlation}

\item{s}{number of control variables}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a Fisher confidence interval for a population Pearson correlation
or partial correlation with s control variables. Set s = 0 for a Pearson
correlation. A bias adjustmentment is used to reduce the bias of the Fisher
transformed correlation. This function uses an estimated correlation as
input. Use the cor.test function for raw data input.
}
\examples{
ci.cor(.05, .536, 0, 50)

# Should return:
# Estimate        SE        LL        UL
#    0.536 0.1018149 0.2978573 0.7058914
 

}
\references{
\insertRef{Snedecor1980}{statpsych}
}
