% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.mean.ws}
\alias{ci.2x2.mean.ws}
\title{Computes tests and confidence intervals of effects in a 2x2 within-subjects
design for means}
\usage{
ci.2x2.mean.ws(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A and level 1 of B}

\item{y12}{vector of scores at level 1 of A and level 2 of B}

\item{y21}{vector of scores at level 2 of A and level 1 of B}

\item{y22}{vector of scores at level 2 of A and level 2 of B}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimate of effect
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals and tests for the AB interaction effect,
main effect of A, main efect of B, simple main effects of A, and simple main
effects of B in a 2x2 within-subjects design with a quantitative response
variable.
}
\examples{
y11 <- c(1,2,3,4,5,7,7)
y12 <- c(1,0,2,4,3,8,7)
y21 <- c(4,5,6,7,8,9,8)
y22 <- c(5,6,8,7,8,9,9)
ci.2x2.mean.ws(.05, y11, y12, y21, y22)

# Should return:
#             Estimate        SE          t df            p          LL          UL
# AB:       1.28571429 0.5654449  2.2738102  6 0.0633355395 -0.09787945  2.66930802
# A:       -3.21428571 0.4862042 -6.6109784  6 0.0005765210 -4.40398462 -2.02458681
# B:       -0.07142857 0.2296107 -0.3110855  6 0.7662600658 -0.63326579  0.49040865
# A at b1: -2.57142857 0.2973809 -8.6469203  6 0.0001318413 -3.29909331 -1.84376383
# A at b2: -3.85714286 0.7377111 -5.2285275  6 0.0019599725 -5.66225692 -2.05202879
# B at a1:  0.57142857 0.4285714  1.3333333  6 0.2308094088 -0.47724794  1.62010508
# B at a2: -0.71428571 0.2857143 -2.5000000  6 0.0465282323 -1.41340339 -0.01516804


}
