% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{power.mean2}
\alias{power.mean2}
\title{Approximates the power of a two-sample t-test for planned sample sizes}
\usage{
power.mean2(alpha, n1, n2, var1, var2, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{n1}{planned sample size for group 1}

\item{n2}{planned sample size for group 2}

\item{var1}{planning value of within-group variance for group 1}

\item{var2}{planning value of within-group variance for group 2}

\item{es}{planning value of mean difference}
}
\value{
Returns the approximate power of the test
}
\description{
Computes the approximate power of a two-sample t-test for planned sample
sizes. For a conservatively low power approximation, set the variance
planning values to the largest values within their plausible ranges,
and set the effect size to a minimally interesting value. The within-group
variances can be unequal across groups and a Satterthwaite degree of freedom
adjustment is used to improve the accuracy of the power approximation.
}
\examples{
power.mean2(.05, 25, 25, 5.0, 6.0, 2)

# Should return:
#          Power
# [1,] 0.8398413


}
