% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTD.R
\name{summary.TD}
\alias{summary.TD}
\title{Summarizing objects of class \code{TD}}
\usage{
\method{summary}{TD}(
  object,
  ...,
  trial = names(object),
  traits,
  groupBy = NULL,
  what = if (!is.null(groupBy)) {     c("nObs", "mean", "sd") } else {     c("nObs",
    "nMiss", "mean", "median", "min", "max", "firstQ", "thirdQ", "var") }
)
}
\arguments{
\item{object}{An object of class TD.}

\item{...}{Further arguments - currently not used.}

\item{trial}{A character string specifying the trial to be summarized.}

\item{traits}{A character vector specifying the traits to be summarized.}

\item{groupBy}{A character string specifying a column in TD by which the
summary should be grouped. If \code{NULL}, no grouping is done.}

\item{what}{A character vector indicating which summary statistics should be
computed. If \code{what = "all"}, all available statistics are computed.\cr
Possible options are:
\describe{
\item{nVals}{The number of values, i.e. non-missing + missing values.}
\item{nObs}{The number of non-missing observations.}
\item{nMiss}{The number of missing values.}
\item{mean}{The mean.}
\item{median}{The median.}
\item{min}{The minimum.}
\item{max}{The maximum.}
\item{range}{The range (maximum - minimum).}
\item{firstQ}{The first (25pct) quantile.}
\item{thirdQ}{The third (75pct) quantile.}
\item{sd}{The standard deviation.}
\item{seMean}{The standard error of mean.}
\item{var}{The variance.}
\item{seVar}{The standard error of variance.}
\item{CV}{The coefficient of variation.}
\item{sum}{The sum.}
\item{sumSq}{The sum of squares.}
\item{uncorSumSq}{The uncorrected sum of squares.}
\item{skew}{The skewness.}
\item{seSkew}{The standard error of the skewness.}
\item{kurt}{The kurtosis.}
\item{seKurt}{The standard error of the kurtosis.}
\item{all}{All summary statistics.}
}}
}
\value{
A table containing the selected summary statistics.
}
\description{
\code{summary} method for class \code{TD}.
}
\examples{
## Summarize TDHeat05.
summary(TDHeat05,
        traits = "yield")

## Summarize TDHeat05 grouping by repId.
summary(TDHeat05,
        traits = "yield",
        groupBy = "repId")

}
\seealso{
Other functions for TD objects: 
\code{\link{TD}},
\code{\link{getMeta}()},
\code{\link{plot.TD}()}
}
\concept{functions for TD objects}
