/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import dag.Dag;
import java.text.DecimalFormat;

public class DagUtil {
    private DagUtil() {
    }

    public static String dagStats(Dag dag) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        int n = 7;
        double d = dag.nEdges();
        double d2 = dag.nNodes();
        double d3 = dag.nLevels();
        long l = (int)Math.round(d / d3);
        double d4 = d / d2;
        int n2 = Math.round(dag.parentWeight(0, 0) / (float)l);
        String string = String.valueOf(l);
        String string2 = String.valueOf(dag.maxEdges());
        String string3 = decimalFormat.format(d4);
        String string4 = String.valueOf(n2);
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("mean edges/level: ");
        stringBuilder.append(string);
        DagUtil.padField(stringBuilder, n - string.length());
        stringBuilder.append("max edges/level: ");
        stringBuilder.append(string2);
        stringBuilder.append(Const.nl);
        stringBuilder.append("mean edges/node:  ");
        stringBuilder.append(string3);
        DagUtil.padField(stringBuilder, n - string3.length());
        stringBuilder.append("mean count/edge: ");
        stringBuilder.append(string4);
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }

    private static void padField(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
    }

    private static int count(int[] nArray, int n) {
        int n2 = 0;
        for (int n3 : nArray) {
            if (n3 != n) continue;
            ++n2;
        }
        return n2;
    }

    private static int count(float[] fArray, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n = 0;
        for (float f2 : fArray) {
            if (f2 != f) continue;
            ++n;
        }
        return n;
    }

    public static int[] removeValues(int[] nArray, int n) {
        int n2 = DagUtil.count(nArray, n);
        int[] nArray2 = new int[nArray.length - n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            nArray2[n3++] = nArray[i];
        }
        assert (n3 == nArray2.length);
        return nArray2;
    }

    public static float[] removeValues(float[] fArray, float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n = DagUtil.count(fArray, f);
        float[] fArray2 = new float[fArray.length - n];
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == f) continue;
            fArray2[n2++] = fArray[i];
        }
        assert (n2 == fArray2.length);
        return fArray2;
    }
}

