% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_lag}
\alias{roll_lag}
\alias{roll_lead}
\title{Apply rollling functions with respect to a time variable}
\usage{
roll_lag(x, FUN, n, along_with = NULL, order_by = NULL, closed = c(TRUE,
  TRUE), ...)

roll_lead(x, FUN, n, along_with = NULL, order_by = NULL, closed = c(TRUE,
  TRUE), ...)
}
\arguments{
\item{x}{a vector or matrix}

\item{FUN}{function to apply on \code{x}}

\item{n}{an integer specifying the rolling window}

\item{along_with}{use this variable to roll the function based on the  \code{[along_with - n, along_with]} rather than past \code{n} rows. NA are not accepted}

\item{order_by}{override the default ordering to use another vector}

\item{closed}{Logical of length 2 (recycled) Should interval be closed ? Default to c(TRUE, TRUE)}

\item{...}{options to pass to the function \code{FUN}}
}
\description{
Apply rollling functions with respect to a time variable
}
\examples{
along_with  = c(1, 2, 4, 7)
x <- c(1, 1, 1, 1)
roll_lag(x,sum, n = 1, along_with = along_with)
roll_lag(x, sum, n = 1, along_with = along_with)
roll_lag(x, sum, n = 2, along_with = along_with)
roll_lead(x, sum, n = 1, along_with = along_with)
roll_lead(x, sum, n = 2, along_with = along_with)
y <- c(1, 2, 1, 1)
roll_lag(list(x,y), function(z){cov(z[[1]], z[[2]])},  n = 2, along_with = along_with)
}

