% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMetaDprime.R
\name{fitMetaDprime}
\alias{fitMetaDprime}
\title{Fits meta-d' and meta-d'/d' ratios for data from one or several subjects}
\usage{
fitMetaDprime(data, model = "ML", nInits = 5, nRestart = 3,
  .parallel = FALSE, n.cores = NULL)
}
\arguments{
\item{data}{a \code{data.frame} where each row is one trial, containing following
variables:
\itemize{
\item \code{rating} (discrete confidence judgments, should be given as factor;
otherwise will be transformed to factor with a warning),
\item \code{stimulus} (stimulus category in a binary choice task,
should be a factor with two levels, otherwise it will be transformed to
a factor with a warning),
\item \code{correct} (encoding whether the response was correct; should  be 0 for incorrect responses and 1 for correct responses)
\item \code{participant} (giving the subject ID; the models given in the second argument are fitted for each
subject individually.
}}

\item{model}{\code{character} of length 1. Either "ML" to use the original model
specification by Maniscalco and Lau (2012,  2014) or "F" to use the model
specification by Fleming (2017)'s HmetaD method.  Defaults to "ML"}

\item{nInits}{\code{integer}. Number of initial values used for maximum likelihood optimization.
Defaults to 5.}

\item{nRestart}{\code{integer}. Number of times the optimization is restarted.
Defaults to 3.}

\item{.parallel}{\code{logical}. Whether to parallelize the fitting over models and participant
(default: FALSE)}

\item{n.cores}{\code{integer}. Number of cores used for parallelization. If NULL (default), the available
number of cores -1 will be used.}
}
\value{
Gives data frame with rows for each participant and columns dprime, c, metaD, and Ratio
\itemize{
\item dprime is the discrimination sensitivity index d, calculated using a standard SDT formula
\item c is the discrimination bias c, calculated using a standard SDT formula
\item metaD is meta-d', discrimination sensitivity estimated from confidence judgments conditioned on the response
\item Ratio is meta-d'/d', a quantity usually referred to as metacognitive efficiency.
}
}
\description{
This function computes meta-d' and meta-d'/d' for each  participant in the \code{data}, respectively.
}
\details{
The function computes meta-d' and meta-d'/d' either using the
hypothetical signal detection model assumed by Maniscalco and Lau (2012, 2014)
or the one assumed by Fleming (2014). The fitting routine first performs a coarse grid search to find promising
starting values for the maximum likelihood optimization procedure. Then the best \code{nInits}
parameter sets found by the grid search are used as the initial values for separate
runs of the Nelder-Mead algorithm implemented in \code{\link[stats]{optim}}.
Each run is restarted \code{nRestart} times. Warning: meta-d'/d'
is only guaranteed to be unbiased from discrimination sensitivity, discrimination
bias, and confidence criteria if the data is generated according to the
independent truncated Gaussian model (see Rausch et al., 2023).
}
\examples{
# 1. Select two subject from the masked orientation discrimination experiment
data <- subset(MaskOri, participant \%in\% c(1:2))
head(data)

# 2. Fit meta-d/d for each subject in data
MetaDs <- fitMetaDprime(data, model="F", .parallel = FALSE)

}
\references{
Fleming, S. M. (2017). HMeta-d: Hierarchical Bayesian estimation of metacognitive efficiency from confidence ratings. Neuroscience of Consciousness, 1, 1–14. doi: 10.1093/nc/nix007

Maniscalco, B., & Lau, H. (2012). A signal detection theoretic method for estimating metacognitive sensitivity from confidence ratings. Consciousness and Cognition, 21(1), 422–430.

Maniscalco, B., & Lau, H. C. (2014). Signal Detection Theory Analysis of Type 1 and Type 2 Data: Meta-d’, Response- Specific Meta-d’, and the Unequal Variance SDT Model. In S. M. Fleming & C. D. Frith (Eds.), The Cognitive Neuroscience of Metacognition (pp. 25–66). Springer. doi: 10.1007/978-3-642-45190-4_3

Rausch, M., Hellmann, S., & Zehetleitner, M. (2023). Measures of metacognitive efficiency across cognitive models of decision confidence. Psychological Methods. doi: 10.31234/osf.io/kdz34
}
\author{
Manuel Rausch, \email{manuel.rausch@hochschule-rhein-waal.de}
}
