% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_pages.R
\name{rotate_pages}
\alias{rotate_pages}
\title{Rotate selected pages of a pdf file}
\usage{
rotate_pages(
  rotatepages,
  page_rotation = c(0, 90, 180, 270),
  input_filepath = NULL,
  output_filepath = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{rotatepages}{a vector of page numbers to be rotated}

\item{page_rotation}{An integer value from the vector c(0, 90, 180, 270).
Each option sets the page orientation as follows:
north: 0, east: 90, south: 180, west: 270. Note that the orientation cannot be
cummulatively changed (eg. 90 (east) will always turn the page so the beginning
of the page is on the right side)}

\item{input_filepath}{the path of the input PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{output_filepath}{the path of the output PDF file. The default is set to
NULL. IF NULL, it  prompt the user to select the folder interactively.}

\item{overwrite}{If a file exists in \code{output_filepath}, should it be overwritten.}
}
\value{
this function returns a PDF document with the
remaining pages
}
\description{
If the toolkit Pdftk is available in the
system, it will be called to rotate the given pages of
the seleted PDF files

See the reference for detailed usage of \code{pdftk}.
}
\examples{
\dontrun{
# This command prompts the user to select the file interactively.
# Rotate page 2 and 6 to 90 degrees clockwise
rotate_pages(rotatepages = c(3,6), page_rotation = 90)
}

\dontrun{
if (requireNamespace("lattice", quietly = TRUE)) {
dir <- tempdir()
for(i in 1:3) {
pdf(file.path(dir, paste("plot", i, ".pdf", sep = "")))
print(lattice::xyplot(iris[,1] ~ iris[,i], data = iris))
dev.off()
}
output_file <- file.path(dir, paste('Full_pdf.pdf',  sep = ""))
staple_pdf(input_directory = dir, output_file)
input_path <- file.path(dir, paste("Full_pdf.pdf",  sep = ""))
output_path <-  file.path(dir, paste("Rotated_pgs_pdf.pdf",  sep = ""))
rotate_pages(rotatepages = c(2,3), page_rotation = 90,  input_path, output_path)
}
}
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\author{
Priyanga Dilini Talagala
}
