% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source_lines.R
\name{source_lines}
\alias{source_lines}
\title{Source Lines from a File}
\usage{
source_lines(file, lines, ...)
}
\arguments{
\item{file}{A character string giving the path to the file to be sourced.}

\item{lines}{A numeric vector of line numbers to be sourced.}

\item{...}{Additional arguments to be passed to \code{\link{source}}.}
}
\value{
The result of \code{\link{source}}.
}
\description{
Sources specific lines from a file
}
\examples{
test_file <- tempfile(fileext = ".R")
writeLines(c("# Line 1", "2+2", "# Line 3"), test_file)
source_lines(test_file, 1:2, echo=TRUE)

}
\seealso{
This function is borrowed from a
\href{https://gist.github.com/christophergandrud/1eb4e095974204b12af9}{gist}
by christophergandrud.
}
