% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morePlots.R
\name{plot_struct_shocks}
\alias{plot_struct_shocks}
\title{Plot structural shock time series of a STVAR model}
\usage{
plot_struct_shocks(stvar)
}
\arguments{
\item{stvar}{object of class \code{"stvar"}}
}
\value{
No return value, called for its side effect of plotting the structural shock time series.
}
\description{
\code{plot_struct_shocks} plots structural shock time series of a structural STVAR model.
  For reduced form models (not identified by non-Gaussianity), recursive identification is assumed.
}
\details{
Plot the time series of the structural shocks of a structural STVAR model.
}
\examples{
## Gaussian STVAR p=1, M=2 model, with weighted relative stationary densities
# of the regimes as the transition weight function:
theta_122relg <- c(0.734054, 0.225598, 0.705744, 0.187897, 0.259626, -0.000863,
  -0.3124, 0.505251, 0.298483, 0.030096, -0.176925, 0.838898, 0.310863, 0.007512,
  0.018244, 0.949533, -0.016941, 0.121403, 0.573269)
mod122 <- STVAR(data=gdpdef, p=1, M=2, params=theta_122relg)

# Plot the times series structural shocks assuming recursive identification:
plot_struct_shocks(mod122)
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation.
     \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{International Economic Review}, \strong{35}:3, 407-414.
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Kilian L., Lütkepohl H. 20017. Structural Vector Autoregressive Analysis. 1st edition.
     \emph{Cambridge University Press}, Cambridge.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{diagnostic_plot}}, \code{\link{fitSTVAR}}, \code{\link{fitSSTVAR}}, \code{\link{STVAR}},
}
