% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrrIII3.R, R/gamma.R, R/gompertz.R,
%   R/invpareto.R, R/lgumbel.R, R/llogis-llogis.R, R/llogis.R, R/lnorm-lnorm.R,
%   R/lnorm.R, R/pqr.R, R/weibull.R
\name{ssd_qburrIII3}
\alias{ssd_qburrIII3}
\alias{ssd_qgamma}
\alias{ssd_qgompertz}
\alias{qgompertz}
\alias{ssd_qinvpareto}
\alias{ssd_qlgumbel}
\alias{qlgumbel}
\alias{ssd_qllogis_llogis}
\alias{ssd_qllogis}
\alias{ssd_qlnorm_lnorm}
\alias{ssd_qlnorm}
\alias{ssd_q}
\alias{ssd_qweibull}
\title{Quantile Function}
\usage{
ssd_qburrIII3(
  p,
  shape1 = 1,
  shape2 = 1,
  scale = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qgamma(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qgompertz(p, location = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

qgompertz(p, llocation = 0, lshape = 0, lower.tail = TRUE, log.p = FALSE)

ssd_qinvpareto(p, shape = 3, scale = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qlgumbel(
  p,
  locationlog = 0,
  scalelog = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

qlgumbel(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qllogis_llogis(
  p,
  locationlog1 = 0,
  scalelog1 = 1,
  locationlog2 = 1,
  scalelog2 = 1,
  pmix = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qllogis(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qlnorm_lnorm(
  p,
  meanlog1 = 0,
  sdlog1 = 1,
  meanlog2 = 1,
  sdlog2 = 1,
  pmix = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_qlnorm(p, meanlog = 0, sdlog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_qweibull(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{shape1}{shape1 parameter.}

\item{shape2}{shape2 parameter.}

\item{scale}{scale parameter.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{location}{location parameter.}

\item{llocation}{location parameter on the log scale.}

\item{lshape}{shape parameter on the log scale.}

\item{locationlog}{location on log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{locationlog1}{locationlog1 parameter.}

\item{scalelog1}{scalelog1 parameter.}

\item{locationlog2}{locationlog2 parameter.}

\item{scalelog2}{scalelog2 parameter.}

\item{pmix}{Proportion mixture parameter.}

\item{meanlog1}{mean on log scale parameter.}

\item{sdlog1}{standard deviation on log scale parameter.}

\item{meanlog2}{mean on log scale parameter.}

\item{sdlog2}{standard deviation on log scale parameter.}

\item{meanlog}{mean on log scale parameter.}

\item{sdlog}{standard deviation on log scale parameter.}
}
\description{
Quantile Function
}
\section{Functions}{
\itemize{
\item \code{ssd_qburrIII3}: Quantile Function for BurrIII Distribution

\item \code{ssd_qgamma}: Quantile Function for Gamma Distribution

\item \code{ssd_qgompertz}: Quantile Function for Gompertz Distribution

\item \code{qgompertz}: Quantile Function for Gompertz Distribution
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{ssd_qinvpareto}: Quantile Function for Inverse Pareto Distribution

\item \code{ssd_qlgumbel}: Quantile Function for Log-Gumbel Distribution

\item \code{qlgumbel}: Quantile Function for Log-Gumbel Distribution
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{ssd_qllogis_llogis}: Cumulative Distribution Function for Log-Logistic/Log-Logistic Mixture Distribution

\item \code{ssd_qllogis}: Cumulative Distribution Function for Log-Logistic Distribution

\item \code{ssd_qlnorm_lnorm}: Cumulative Distribution Function for Log-Normal/Log-Normal Mixture Distribution

\item \code{ssd_qlnorm}: Cumulative Distribution Function for Log-Normal Distribution

\item \code{ssd_qweibull}: Cumulative Distribution Function for Weibull Distribution
}}

\examples{

ssd_qburrIII3(0.5)

ssd_qgamma(0.5)

ssd_qgompertz(0.5)

ssd_qinvpareto(0.5)

ssd_qlgumbel(0.5)

ssd_qllogis_llogis(0.5)

ssd_qllogis(0.5)

ssd_qlnorm_lnorm(0.5)

ssd_qlnorm(0.5)

ssd_qweibull(0.5)
}
\seealso{
\code{\link{ssd_p}} and \code{\link{ssd_r}}
}
