% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_lcomp_constant.R
\name{change_lcomp_constant}
\alias{change_lcomp_constant}
\title{Set the robustification constant for length composition data.}
\usage{
change_lcomp_constant(lcomp_constant, dat_list, dat_file_out,
  write_file = TRUE)
}
\arguments{
\item{lcomp_constant}{*The new value to be used. Must be a numeric value, as
a proportion. For example 0.1 means 10 percent. See the SS3 manual for
further information. A NULL value indicates no action resulting in using
the current value, and a value of 0 will throw an error since that leads to
an error when zeroes exist in the data. Instead use a very small value like
1e-07.}

\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{dat_file_out}{A string providing the path to the output SS3 \code{.dat} file.}

\item{write_file}{Should the data file be written to disk?}
}
\value{
A modified SS3 \code{.dat} file, and that file returned invisibly
  (for testing) as a vector of character lines.
}
\description{
This function replaces the robustification value for length composition data
in a \code{.dat} file that was read in using \code{\link[r4ss]{SS_readdat}}
with those specified in
\code{lcomp_constant}. It then writes a new file with name \code{dat_file_out}
into the working directory. If used with \code{\link{run_ss3sim}} the case
file should be named \code{lcomp_constant}. A suggested case letter is
\code{C}.
}
\details{
The robustification constant is added to both the observed and
  expected proportions of length composition data, before being normalized
  internally. It is designed to help stabilize the model, but is unclear how
  and when to use it for optimal effect. The same value is used for all
  length data.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\author{
Cole Monnahan
}
