% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_re.R
\name{calculate_re}
\alias{calculate_re}
\title{Calculate relative error}
\usage{
calculate_re(dat, add = TRUE)
}
\arguments{
\item{dat}{An input data frame. Should be either a scalar or time series
data frame as returned from \code{\link{get_results_all}} or a related
get results function. Specifically, the data frame needs to have columns
with \code{_em} and \code{_om} as names.}

\item{add}{Logical: should the relative error columns be added to \code{dat}
or should the original EM and OM columns be dropped? If \code{FALSE} then
the returned data frame will have only the identifying columns and the new
relative error columns. You could then merge selected columns back into
\code{dat} if you wished.}
}
\description{
Takes a scalar or time series data frame from an \pkg{ss3sim} run and
calculates relative error (em - om) / em.
}
\examples{
# Example with built in package data:
d1 <- system.file("extdata", "output", "ss3sim_ts.csv",
  package = "ss3sim")
d2 <- system.file("extdata", "output", "ss3sim_scalar.csv",
  package = "ss3sim")
ss3sim_ts <- read.csv(d1)
ss3sim_scalar <- read.csv(d2)

head(calculate_re(ss3sim_ts))
head(calculate_re(ss3sim_ts, add = FALSE))
head(calculate_re(ss3sim_scalar, add = FALSE))

\dontrun{
# Full example:
d <- system.file("extdata", package = "ss3sim")
om <- paste0(d, "/models/cod-om")
em <- paste0(d, "/models/cod-em")
case_folder <- paste0(d, "/eg-cases")

run_ss3sim(iterations = 1, scenarios = "D0-F0-cod",
  case_folder = case_folder, om_dir = om, em_dir = em, ss_mode = "optimized")

get_results_all(user_scenarios = "D0-F0-cod")
ss3sim_ts <- read.csv("ss3sim_ts.csv")
ss3sim_scalar <- read.csv("ss3sim_scalar.csv")

head(calculate_re(ss3sim_ts))
head(calculate_re(ss3sim_scalar, add = FALSE))

# clean up:
unlink("D0-F0-cod", recursive = TRUE)
unlink("ss3sim_ts.csv", recursive = TRUE)
unlink("ss3sim_scalar.csv", recursive = TRUE)
}
}
\seealso{
\code{\link{get_results_all}}, \code{link{get_results_scenario}}
}
\author{
Sean Anderson and Cole Monnahan
}
