% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_bounds.R
\name{standardize_bounds}
\alias{standardize_bounds}
\title{Standardize the bounds of the estimation model control file.}
\usage{
standardize_bounds(percent_df, dir, em_ctl_file, om_ctl_file = "",
  verbose = FALSE, estimate = NULL, ...)
}
\arguments{
\item{percent_df}{A \code{data.frame} with nine rows and three columns.
The first column is the parameter.
The second column is the percent of the initial parameter value LO is set to.
The third column is the percent of the initial parameter value HI is set to.}

\item{dir}{A path to the directory containing the model files.}

\item{em_ctl_file}{A string with the name of the estimation model
control file. \code{em_ctl_file} must be located in \code{dir}.}

\item{om_ctl_file}{A string with the name of the operating model
control file. If it is not given the part of the function which matches the
OM and EM INIT values is ignored. Default is \code{""}.
\code{om_ctl_file} must be located in \code{dir}.}

\item{verbose}{Detailed output to command line. Default is \code{FALSE}.}

\item{estimate}{A logical for which changed parameters are to be estimated.
Used by \code{\link[r4ss]{SS_changepars}}, where in \pkg{r4ss} the default
is \code{FALSE}, which turns all parameter estimation off. Here the default
is \code{NULL}, which will leave parameter phases unchanged.}

\item{...}{Any other arguments to pass to \code{\link[r4ss]{SS_changepars}}.}
}
\description{
Function to standardize the bounds of the control file in the estimation
model. This function first checks to ensure the initial values in the
estimation model control file are set to the true values of the
\code{om_ctl_file} and if not sets them for every parameter. Next, the
function adjusts the LO and HI values in the \code{em_ctl_file} to
be a fixed percentage of the initial value for every parameter.
}
\examples{
\dontrun{
temp_path <- file.path(tempdir(), "standardize-bounds-example")
dir.create(temp_path, showWarnings = FALSE)
wd <- getwd()
setwd(temp_path)

## Set to the path and filename of the OM and EM control files
OM.ctl <- system.file("extdata", "models", "cod-om", "codOM.ctl",
  package = "ss3sim")
EM.ctl <- system.file("extdata", "models", "cod-em", "codEM.ctl",
  package = "ss3sim")
file.copy(OM.ctl, "om.ctl")
file.copy(EM.ctl, "em.ctl")

## Use SS_parlines to get the proper names for parameters for the data frame
om.pars <- r4ss::SS_parlines(ctlfile="om.ctl")
em.pars <- r4ss::SS_parlines(ctlfile="em.ctl")

## Set percentages to make lower and upper bounds
lo.percent<-rep(.5,11)
hi.percent<-c(500,1000,1000,rep(500,8))

##Populate data frame using EM parameter names and percentages
percent_df<-data.frame(Label=as.character(em.pars[c(1:6,17,27:30),"Label"]),
  lo=lo.percent,hi=hi.percent)

##Run function
standardize_bounds(percent_df = percent_df, dir = temp_path, em_ctl_file = "em.ctl",
                   om_ctl_file = "om.ctl")
unlink(temp_path, recursive = TRUE)

setwd(wd)
}
}
\author{
Christine Stawitz
}

