% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_historical_rankings.R
\name{get_historical_rankings}
\alias{get_historical_rankings}
\title{Get historical PSA rankings from SquashInfo}
\usage{
get_historical_rankings(year = NULL, month = NULL, category = NULL, top = NULL)
}
\arguments{
\item{year}{integer indicating the ranking year}

\item{month}{three letter abbreviation of ranking month}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}

\item{top}{integer indicating the number of top PSA players by rank to return.}
}
\value{
Tibble containing the ranking year, ranking month, exact date, rank, player name, and player current rank.
}
\description{
Given a year, abbreviated month, competition category, and number of top players, \code{get_historical_rankings()} returns the corresponding historical PSA rankings table.
}
\note{
This function takes substantial time to scrape the corresponding data because historical ranking tables are not available to non-premium members on SquashInfo. The historical rankings returned by this function are reverse-engineered from individual player ranking histories.
}
\examples{

## Who were the top 5 players in both men's and women's singles in January 2019?
\donttest{\dontrun{top5 <- get_historical_rankings(2019, "Jan", "both", 5)}}

}
\references{
\url{http://www.squashinfo.com/players}
}
