% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLtoUTM.R
\name{LLtoTM}
\alias{LLtoTM}
\title{Convert Latitude and Longitude spatial coordinates to transverse Mercator (TM) projection coordinates
with a user-defined central meridian.}
\usage{
LLtoTM(cm, lat, lon, xcol = "x", ycol = "y", minx = NULL, miny = NULL)
}
\arguments{
\item{cm}{is the user defined central median. A common choice is the
mean of the longitude values in your data set}

\item{lat}{is the vector of latitudes}

\item{lon}{is the vector of longitudes}

\item{xcol}{is the name of the output TM column of x coordinates}

\item{ycol}{is the name of the output TM column of y coordinates}

\item{minx}{is `NULL` by default and sets the minimum x-coordinate value to 0. This is an optional minimum value for the x-coordinate vector.}

\item{miny}{is `NULL` by default and sets the minimum y-coordinate value to 0. This is an optional minimum value for the y-coordinate vector.}
}
\value{
A list with the TM coordinates as the first component of the list. The first component of the list contains x coordinates in the first column and y coordinates in the second column. The remaining elements of the list are the \code{cm}, \code{minx}, and \code{miny} values that were input.
}
\description{
The resulting units from applying the function are kilometers.
}
\details{
This function only should only be used if the coordinates supplied by the
user are latitude and longitude. The default TM projection here specifies
that both the minimum x and y-coordinate values are 0 scaled to 1 km.
}
\examples{
## Add transverse Mercator x and y coordinates to a data frame with
## latitude/longitude coordinates. Name these \code{xc_TM_} and \code{yc_TM_}.
exampledataset$xc_TM_ <- LLtoTM(cm = base::mean(exampledataset[ ,"xcoords"]),
 lat = exampledataset[ ,"ycoords"],
 lon = exampledataset[ ,"xcoords"])$xy[ ,1]
exampledataset$yc_TM_ <- LLtoTM(cm = base::mean(exampledataset[ ,"xcoords"]),
 lat = exampledataset[ ,"ycoords"],
 lon = exampledataset[ ,"xcoords"])$xy[ ,2]
}
