% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shypFun.04110.R
\name{shypFun.04110}
\alias{shypFun.04110}
\title{Unimodal Brooks-Corey Model}
\usage{
shypFun.04110(p, h)
}
\arguments{
\item{p}{vector of the 6 Brooks-Corey model parameters, order is sensitve and has to be given as:
\tabular{lll}{
      \code{thr}\tab{residual water water content [cm cm-3]}\cr
      \code{ths}\tab{saturated water water content [cm cm-3]}\cr
      \code{alf}\tab{air entry pressure head [cm^-1]}\cr
      \code{bet}\tab{effective model parameter [ - ]}\cr
      \code{Ks}\tab{saturated conductivity [cm d-1]}\cr
      \code{tau}\tab{exponent of \code{Se} in the capillary conductivity model, sometimes denoted in the literature as \code{l} [-]}\cr
         }}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{theta}{calculated volumetric moisture content}
\item{Se}{calculated saturation}
\item{cap}{returns NA; not supported}
\item{psd}{returns NA; not supported}
\item{Kh}{Hydraulic conductivity values}
}
\description{
Calculates the soil hydraulic property function values based on given pressure heads \insertCite{Kosugi.1996}{spsh}.
}
\details{
The function solves analytically the spec. water capacity function and integral to the capillary bundle model.
}
\note{
The Muealm integral is solved numerically
}
\examples{
p      <- c(0.1, 0.4, .01, .3, 100, .5)
h      <- 10^seq(-2, 6.8, length = 197)
shyp.L <- shypFun.04110(p, h)
}
\references{
\insertRef{Brooks.1964}{spsh}
}
