% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsServerCollections.R
\name{spsValidate}
\alias{spsValidate}
\title{Validate expressions}
\usage{
spsValidate(
  expr,
  vd_name = "my validation",
  pass_msg = glue("validation: '{vd_name}' passed"),
  shiny = TRUE,
  verbose = spsOption("verbose"),
  prefix = ""
)
}
\arguments{
\item{expr}{the expression to validate data or other things. Use
\code{stop("your message")} or generate some errors inside to fail the validation.
If there is no error, it will return \code{TRUE} and display \code{pass_msg} on both
console and shiny app if \code{verbose = TRUE} or global SPS option verbose is \code{TRUE}.

If the expression fails, it will block the code following this function within
the same reactive domain to continue, similar to \code{\link[=shinyCatch]{shinyCatch()}}.}

\item{vd_name}{validate title}

\item{pass_msg}{string, if pass, what message do you want to show}

\item{shiny}{bool, show message on console but hide from users?
see \code{\link[=shinyCatch]{shinyCatch()}} for more details}

\item{verbose}{bool, show pass message? Default follows global verbose
setting, use \link[spsUtil:spsOption]{spsUtil::spsOption} to set up the value \code{spsOption("verbose, TRUE")}
to turn on and \code{spsOption("verbose, FALSE")} to turn off and \code{spsOption("verbose")}
to check current setting, see examples.}

\item{prefix}{see \code{prefix} in \code{\link[=shinyCatch]{shinyCatch()}}}
}
\value{
If expression fails, block the code following this validation function
and no final return, else \code{TRUE}.
}
\description{
this function is used on server side to usually validate input
dataframe or some expression. The usage is similar to \link[shiny:validate]{shiny::validate} but is
not limited to shiny render functions and
provides better user notification and server-end logging (dual-end logging).
}
\details{
\itemize{
\item To have the message displayed on shiny, \code{spsDepend("toastr")} must be added
in UI if you are working on you own app not under SPS framework, see examples.
}
}
\examples{
if(interactive()){
    ui <- fluidPage(
        spsDepend("toastr"), # need to add toastr dependency
        column(
            4,
            h3("click below to make the plot"),
            p("this button will succeed, verbose on"),
            actionButton("vd1", "make plot 1"),
            plotOutput("p1")
        ),
        column(
            4,
            h3("click below to make the plot"),
            p("this button will succeed, verbose off"),
            actionButton("vd2", "make plot 2"),
            plotOutput("p2")
        ),
        column(
            4,
            h3("click below to make the plot"),
            p("this button will fail, no plot will be made"),
            actionButton("vd3", "make plot 3"),
            plotOutput("p3")
        ),
        column(
            4,
            h3("click below to make the plot"),
            p("this button will fail, but the message is hidden from users"),
            actionButton("vd4", "make plot 4"),
            plotOutput("p4")
        )
    )
    server <- function(input, output, session) {
        mydata <- datasets::iris
        observeEvent(input$vd1, {
            spsOption("verbose", TRUE) # use global sps verbose setting
            spsValidate({
                is.data.frame(mydata)
            }, vd_name = "Is dataframe")
            output$p1 <- renderPlot(plot(iris$Sepal.Length, iris$Sepal.Width))
        })
        observeEvent(input$vd2, {
            spsValidate({
                is.data.frame(mydata)
            },
            vd_name = "Is dataframe",
            verbose = FALSE) # use in-function verbose setting
            output$p2 <- renderPlot(plot(iris$Sepal.Length, iris$Sepal.Width))
        })
        observeEvent(input$vd3, {
            spsValidate({
                is.data.frame(mydata)
                if(nrow(mydata) <= 200) stop("Input needs more than 200 rows")
            })
            print("other things blocked")
            output$p3 <- renderPlot(plot(iris$Sepal.Length, iris$Sepal.Width))
        })
        observeEvent(input$vd4, {
            spsValidate({
                is.data.frame(mydata)
                if(nrow(mydata) <= 200) stop("Input needs more than 200 rows")
            }, shiny = FALSE)
            print("other things blocked")
            output$p4 <- renderPlot(plot(iris$Sepal.Length, iris$Sepal.Width))
        })
    }
    shinyApp(ui, server)
}
# outside shiny example
mydata2 <- list(a = 1, b = 2)
spsValidate({(mydata2)}, "Not empty")
try(spsValidate(stopifnot(is.data.frame(mydata2)), "is dataframe?"), silent = TRUE)
}
