% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefaction.overlap.R
\name{rarefaction.overlap}
\alias{rarefaction.overlap}
\title{Rarefaction Overlap}
\usage{
rarefaction.overlap(x, y, f0.func, n.rare = NULL, ...)
}
\arguments{
\item{x, y}{two vectors of species frequencies where the \code{i-th} element is the 
number of species represented by only \code{i} samples.}

\item{f0.func}{function to use to calculate f0. Can be \code{\link{Chao1}},
\code{\link{ACE}}, \code{\link{jack1}}, \code{\link{jack2}}, 
\code{\link{iChao1}}, or \code{\link{Swor1}}.}

\item{n.rare}{sample size to rarefy both populations to. Must be <= the minimum
sample size. If \code{NULL}, the minimum sample size is used.}

\item{...}{other arguments to \code{f0.func}.}
}
\value{
a vector with the percent of overlap between the two distributions, 
  the sample size, and species estimates for the \code{x} and 
  \code{y} vectors.
}
\description{
Calculate the percent of overlap between two 
  species estimate distributions where the larger sample size has been
  rarefied to match the smaller sample size.
}
\details{
Calculates the expected number of species and the standard 
  deviation for the smaller sample size of \code{x} and \code{y} using 
  the frequency distributions of each. The function then fits a gamma 
  distribution to each of these estimates, and returns the percent of overlap
  as the integral of the mininum value of the PDF for the two distributions. 
  Integration takes place from 0 to the largest quantile representing 
  0.99999 of either distribution.
}
\examples{
data(osa.old.growth)
data(osa.second.growth)
x <- expand.freqs(osa.old.growth)
y <- expand.freqs(osa.second.growth)
rarefaction.overlap(x, y, Chao1)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Colwell, R.K., A. Chao, N.J. Gotelli, S.-Y. Lin, C.X. Mao, 
  R.L. Chazdon, and J.T. Longino. 2012. Models and estimators linking 
  individual-based and sample-based rarefaction, extrapolation and 
  comparison of assemblages. Journal of Plant Ecology 5(1):3-21.
}
\seealso{
\code{\link{discovery.curve}}
}

