% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix.R
\name{rmixsurf}
\alias{rmixsurf}
\title{Generate a Poisson process surface object}
\usage{
rmixsurf(m, lambda, sig0, df, rand_m = FALSE, xlim, ylim, dvec, mu0, Sigma0)
}
\arguments{
\item{m}{Number of components of the mixture. If omitted, m is uniformly selected from
1 up to 10.}

\item{lambda}{Average number of points over the window. If omitted
lambda is generated from a Gamma with shape~Unif(1,10) and
scale~Unif(50,100).}

\item{sig0}{Tuning parameter for generating a random matrix from an Inverse Wishart
distribution.}

\item{df}{Degrees of freedom for generating a random matrix from an Inverse Wishart
distribution.}

\item{rand_m}{Request a random number of components.
When \code{rand_m = TRUE}, the function will
randomly choose a number of components from
\code{1:m}.}

\item{xlim, ylim}{Vectors defining the observation window.
The component means are sampled uniformly over this window.}

\item{dvec}{A vector of weights used in the Dirichlet distribution used to sample the mixture probabilities. If the dimension of dvec is not
the same as the number of components, then dvec is either truncated to the same dimension or repeated to have dimension m. If missing, a vector of ones is used.}

\item{mu0, Sigma0}{Mean and covariance matrix for a multivariate normal distribution, used to generate all component means. If mu0 is missing the center of the window
is used. If Sigma0 is missing it is set to the identity matrix. If both mu0 and Sigma0 are missing, the component means are generated uniformly over the window of observation.}
}
\value{
Object of class \code{intensity_surface}.
}
\description{
This function creates a Poisson point process intensity
surface modeled as a mixture of normal components, on the given
2d window. The means, covariances and component probabilities
are chosen randomly based on parameters passed to the
function. The number of components can be either fixed or random.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#rmixsurf}
}
\examples{
\donttest{
mixsurf1 <- rmixsurf(m = 3, lambda=100)
summary(mixsurf1)
plot(mixsurf1)
plotmix_2d(mixsurf1)
mixsurf2 <- rmixsurf(m = 5, lambda=200, rand_m = TRUE, ylim = c(-3, 3))
summary(mixsurf2)
plot(mixsurf2)
plotmix_2d(mixsurf2)
mixsurf3 <- rmixsurf(m = 5, lambda=200, rand_m = TRUE, Sigma0=.01*diag(2))
summary(mixsurf3)
plot(mixsurf3)
plotmix_2d(mixsurf3)}

}
\seealso{
\code{\link{plotmix_2d}},
\code{\link{summary.intensity_surface}},
\code{\link{plot.intensity_surface}}
}
\author{
Sakis Micheas
}
