% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix.R
\name{rnormmix}
\alias{rnormmix}
\title{Generate a mixture with normal components}
\usage{
rnormmix(m, sig0, df = 10, rand_m = FALSE, xlim = c(0, 1), ylim = c(0,
  1))
}
\arguments{
\item{m}{Number of components of the mixture.}

\item{sig0}{Tuning parameter for generating a random matrix from a Wishart
distribution. If this argument is missing it is set to .1 of the minimum width/height of the window.}

\item{df}{Degrees of freedom for generating a random matrix from a Wishart
distribution. Default is 10.}

\item{rand_m}{Request a random number of components.
When \code{rand_m = TRUE}, the function will
randomly choose a number of components from
\code{1:m}.}

\item{xlim, ylim}{Vectors defining the observation window.
The component means are sampled uniformly over this window.}
}
\value{
Object of class \code{normmix}.
}
\description{
Generates a mixture on a 2d window where the means, covariances and component probabilities
are chosen randomly. The number of components can be either fixed or random.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#rnormmix}
}
\examples{

\dontrun{
mix1 <- rnormmix(m = 3, sig0 = .1, df = 5)
summary(mix1)
mix2 <- rnormmix(m = 5, sig0 = .1, df = 5, rand_m = TRUE, ylim = c(0, 5))
summary(mix2)}

}
\author{
Yuchen Wang, Sakis Micheas
}

