% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow.R
\name{unfollow_playlist}
\alias{unfollow_playlist}
\title{Remove Current User from Followers of Playlist.}
\usage{
unfollow_playlist(
  playlist_id,
  authorization = get_spotify_authorization_code()
)
}
\arguments{
\item{playlist_id}{Required. The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} of the playlist that is to be no longer followed.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. \cr
Unfollowing a publicly followed playlist for a user requires authorization of the
\code{playlist-modify-public} scope; unfollowing a privately followed playlist requires the
\code{playlist-modify-private} scope. See
\href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}. \cr
Note that the scopes you provide relate only to whether the current user is following the
playlist publicly or privately (i.e. showing others what they are following),
not whether the playlist itself is public or private.}
}
\value{
The response from the Spotify Web API on the \code{DELETE} request, with a meaningful
error message if the operation was not successful.
}
\description{
Remove Current User from Followers of Playlist.
}
