% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_artist_albums}
\alias{get_artist_albums}
\title{Get Spotify catalog information for multiple artists identified by their Spotify IDs.}
\usage{
get_artist_albums(
  id,
  include_groups = c("album", "single", "appears_on", "compilation"),
  market = NULL,
  limit = 20,
  offset = 0,
  authorization = get_spotify_access_token(),
  include_meta_info = FALSE
)
}
\arguments{
\item{id}{The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the artist.}

\item{include_groups}{Optional. A character vector of keywords that will be used to filter the response. If not supplied, all album types will be returned. Valid values are: \cr
\code{"album"} \cr
\code{"single"} \cr
\code{"appears_on"} \cr
\code{"compilation"} \cr
For example: \code{include_groups = c("album", "single")}}

\item{market}{Optional. \cr
An ISO 3166-1 alpha-2 country code or the string \code{"from_token"}. \cr
Supply this parameter to limit the response to one particular geographical market. For example, for albums available in Sweden: \code{market = "SE"}. \cr
If not given, results will be returned for all markets and you are likely to get duplicate results per album, one for each market in which the album is available!}

\item{limit}{Optional. \cr
Maximum number of results to return. \cr
Default: 20 \cr
Minimum: 1 \cr
Maximum: 50 \cr}

\item{offset}{Optional. \cr
The index of the first album to return. \cr
Default: 0 (i.e., the first album). \cr
Use with limit to get the next set of albums.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing artist data. See \url{https://developer.spotify.com/documentation/web-api/reference/artists/get-several-artists/} for more information.
}
\description{
Get Spotify catalog information for multiple artists identified by their Spotify IDs.
}
\seealso{
Other artist functions: 
\code{\link{get_artist_top_tracks}()},
\code{\link{get_artists}()},
\code{\link{get_artist}()},
\code{\link{get_my_followed_artists}()},
\code{\link{get_related_artists}()}
}
\concept{artist functions}
