% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbl_run.R
\name{dbl_run}
\alias{dbl_run}
\title{DBL rating algorithm}
\usage{
dbl_run(formula, data, r, rd, beta, weight, idlab, kappa = 0.5,
  init_r = 0, init_rd = 1, pb = FALSE)
}
\arguments{
\item{formula}{formula specifying model. DBL allows multiple variables in formula, also two-way interaction are available specified by `:`. `dbl` formula require first variable to be player name or identifier. LHS needs `rank|id`, to specify competitors order and event `id`.}

\item{data}{data.frame which contains columns specified in formula, and optionaly columns defined by `beta`, `weight` or `date`.}

\item{r}{named vector of initial estimates. If there is no assumption, initial ratings is set to be r=0.}

\item{rd}{named vector of initial variance of `r` estimates. In there is no assumption, initial is set to be rd=1.}

\item{beta}{The additional variance of performance. As beta increases, the performance is more uncertain and update change is smaller. By default `beta = 25/6`.}

\item{weight}{name of column in `data` containing weights. Weights increasing or decreasing update change. Higher weight increasing impact of corresponding event.}

\item{idlab}{name of column in `data` containing date. Doesn't affect estimation process. If specified, charts displays estimates changes in time in}

\item{kappa}{parameter controlling `rd` to avoid quick decreasing to zero. Is the proportion of `rd` which is maximum change size.}

\item{init_r}{initial values for `r` if not provided. Default `r=0`}

\item{init_rd}{initial values for `rd` if not provided. Default `rd=1`}

\item{pb}{logical, if TRUE progress bar will appear in console. Default = FALSE}
}
\value{
A "rating" object is returned
\itemize{
  \item \code{final_r} named vector containing players ratings.
  \item \code{final_rd} named vector containing players ratings deviations.
  \item \code{r} data.frame with evolution of the ratings and ratings deviations estimated at each event.
  \item \code{pairs} pairwise combinations of players in analysed events with prior probability and result of a challange.
  \item \code{class} of the object
  \item \code{method} type of algorithm used
  \item \code{formula} modelled formula
}
}
\description{
DBL rating algorithm
Wrapper arround `dbl` update algorithm. Wrapper allows user to simplify calculation providing only data and initial parameters assumptions
}
\examples{
data <- data.frame( name = c( "A", "B", "C", "D" ), 
                    rank = c( 3, 4, 1, 2 ))
dbl <- dbl_run( rank ~ name, data)
}
