% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{spaghettiPlot}
\alias{spaghettiPlot}
\title{Create a faceted spaghetti plot of a splinetree model}
\usage{
spaghettiPlot(model, colors = NULL)
}
\arguments{
\item{model}{a splinetree object}

\item{colors}{optional argument specifying colors to be used for each panel.}
}
\description{
Uses ggplot to create a paneled spaghetti plot of the data, where each panel corresponds to a terminal node in the tree.
Allows users to visualize homogeneity of trajectories within the terminal nodes of the tree while also looking
at the trajectories of different nodes side by side.
}
\examples{
\donttest{
split_formula <- ~HISP + WHITE + BLACK + SEX + Num_sibs + HGC_FATHER + HGC_MOTHER
tree <- splineTree(split_formula, BMI~AGE, idvar = "ID",
   data = nlsySample, degree = 1, df = 3,
   intercept = TRUE, cp = 0.005)
}
spaghettiPlot(tree)
}
