% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiro_smooth.R
\name{spiro_smooth}
\alias{spiro_smooth}
\title{Apply a smoothing filter to data from cardiopulmonary exercise testing.}
\usage{
spiro_smooth(data, smooth = 30, columns = NULL, quiet = FALSE)
}
\arguments{
\item{data}{A data frame of the class \code{spiro}. Usually the output of
the \code{\link{spiro} function}.}

\item{smooth}{An integer or character string specifying the smoothing
strategy and parameters. Default is \code{30}, which means the applied
filter is a 30-second moving average. See the section
\strong{'Filtering Methods'} for more details.}

\item{columns}{A character vector of the data columns that should be
filtered. By default the filtering applies to all data column of
\code{data} (besides load, time and step).}

\item{quiet}{Whether warning message should be suppressed. Default is FALSE.}
}
\value{
A data frame
}
\description{
Filter vectors and data frames with moving averages and digital filters.
Provides the data filtering for \code{\link{spiro_max}} and
\code{\link{spiro_plot}}.
}
\details{
Raw data from cardiopulmonary is usually noisy due to measurement errors and
biological breath-to-breath variability. When processing or visualizing the
gas exchange data, it is often helpful to filter the raw data. This function
provides different filtering methods (time average, breath average, digital
filters).

Breath-based and digital filters will be applied on the raw breath-by-breath
data. Time-based averages will be conducted on the interpolated data.
}
\section{Filtering Methods}{

\describe{
\item{Time-Based Average (e.g. \code{smooth = 30})}{A (centered) moving
average over a defined timespan. The number can be given as an integer or
as a character (e.g. \code{smooth = "30"}) and defines the length of the
calculation interval in seconds.}
\item{Breath-Based Average (e.g. \code{smooth = "15b"})}{A (centered)
moving average over a defined number of breaths. The integer before the
letter 'b' defines the number of breaths for the calculation interval.}
\item{Butterworth filter (e.g. \code{smooth = "0.04f3"})}{A digital
Butterworth filter (with lag). The number before the letter 'f' defines
the low-pass cut-off frequency, the number after gives the order of the
filter. See \code{\link{bw_filter}} for more details.}
\item{Zero-lag Butterworth filter (e.g. \code{smooth = "0.04fz3"})}{A
digital forwards-backwards Butterworth filter (without lag). The number
before the letter 'f' defines the low-pass cut-off frequency, the number
after gives the order of the filter. See \code{\link{bw_filter}} for more
details.}
}
}

\examples{
# Get example data
file <- spiro_example("zan_gxt")
d <- spiro(file)

out <- spiro_smooth(d, 30)
head(out)

# filter only the VO2 column with a zero-phase Butterworth filter
out2 <- spiro_smooth(d, "0.04fz3", columns = "VO2")
head(out2)
}
