% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{sprem}
\alias{sprem}
\title{Remove Alternate Values of a Matrix of Mid-infrared Spectra}
\usage{
sprem(spectra, n = 1)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{n}{numeric. Number of removed values between two variables. Defaults to 1.}
}
\value{
A matrix spectra with removed values. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.
}
\description{
Allow to remove alternate values of a matrix of Mid-Infrared Spectra
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Removed spectra
rem <- sprem(spectra=spectra, n=1)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

