% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spew.R
\name{spew_place}
\alias{spew_place}
\title{Generate synthetic ecosystem for single place}
\usage{
spew_place(index, pop_table, shapefile, pums_h, pums_p, schools = NULL,
  workplaces = NULL, marginals = NULL, output_type = "console",
  sampling_method = "uniform", locations_method = "uniform",
  convert_count = FALSE, output_dir = NULL, road_noise = 2e-04,
  timer = FALSE, verbose = FALSE)
}
\arguments{
\item{index}{specfic row of pop-table to generate}

\item{pop_table}{dataframe where rows correspond to places where populations 
should be generated. Other requird columns are "n_house" and "puma_id"}

\item{shapefile}{sp class object used for assigning households to 
particular locations}

\item{pums_h}{dataframe with microdata corresponding to housegolds}

\item{pums_p}{dataframe with microdata corresponding to people}

\item{schools}{list with names "public" and "private" with a 
dataframe of schools corresponding to public or private, respectively}

\item{workplaces}{dataframe of workplaces with a workplace_id column, 
employees column, and stcotr column}

\item{marginals}{list of marginal population totals. Each element of the 
list contains the marginal totals of a separate variable}

\item{output_type}{Default is "console" if we want to resulting population 
as an R variable. Alternative is "write", which is used on Olympus for writing 
out .csv files of the population}

\item{sampling_method}{character indicating the type of sampling 
method to use, defaults to "uniform". Can also be "ipf" with appropriate marginal data.}

\item{locations_method}{character indicating the type of location 
sampling to use, defaults to "uniform", can also be "roads".}

\item{convert_count}{logical meant to indicate if we are going to convert 
population totals from people to household counts. Default: FALSE, assumes
the population is the total number of households}

\item{output_dir}{directory to write output if output_type = "write", NULL otherwise}

\item{road_noise}{Noise added to households during road-based sampling}

\item{timer}{logical indicating we want to time the run}

\item{verbose}{logical indicating we want to print output during the run.  Default is FALSE.#'}
}
\value{
List of a synthetic ecosystem
}
\description{
Used by 'spew' to split the generated of synthetic ecosytstems 
into independent regions.
}
\examples{
data(tartanville)
tartanville_T1 <- spew_place(index = 1, 
                             pop_table = tartanville$pop_table, 
                             shapefile = tartanville$shapefile, 
                             pums_h = tartanville$pums_h, 
                             pums_p = tartanville$pums_p)
                             
}
