/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.FlatPanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.FlatTabTransmitter;
import bibliothek.gui.dock.common.intern.color.FlatTitleTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFlatTheme
extends CDockTheme<FlatTheme> {
    public CFlatTheme(CControl control, FlatTheme theme) {
        super(theme);
        this.init(control);
    }

    public CFlatTheme(CControl control) {
        this(new FlatTheme());
        this.init(control);
    }

    private CFlatTheme(FlatTheme theme) {
        super(theme, new NoStackTheme(theme));
    }

    private void init(final CControl control) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                FlatTabTransmitter transmitter = new FlatTabTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                FlatTitleTransmitter transmitter = new FlatTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                BasicButtonTitleTransmitter transmitter = new BasicButtonTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.initDefaultFontBridges(control);
    }

    @Override
    public void install(DockController controller) {
        super.install(controller);
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new FlatPanelPopupGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController controller) {
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
        super.uninstall(controller);
    }
}

