/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.OrientationToRotationStrategy;
import bibliothek.gui.dock.title.OrientationToRotationStrategyListener;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import bibliothek.util.Condition;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDockTitle
extends JPanel
implements DockTitle {
    private static final Insets DEFAULT_INSETS_HORIZONTAL = new Insets(0, 1, 0, 1);
    private static final Insets DEFAULT_INSETS_VERTICAL = new Insets(1, 0, 1, 0);
    private Dockable dockable;
    private OrientedLabel label = new OrientedLabel(){

        protected void updateFonts() {
            AbstractDockTitle.this.updateFonts();
        }
    };
    private ButtonPanel itemPanel;
    private Listener listener = new Listener();
    private DockTitleVersion origin;
    private boolean active = false;
    private boolean bound = false;
    private boolean showMiniButtons = true;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Icon icon;
    private List<AbstractDockColor> colors = new ArrayList<AbstractDockColor>();
    private List<AbstractDockFont> fonts = new ArrayList<AbstractDockFont>();
    private List<ConditionalFont> conditionalFonts;
    private PropertyValue<OrientationToRotationStrategy> orientationConverter = new PropertyValue<OrientationToRotationStrategy>(DockTitle.ORIENTATION_STRATEGY){

        @Override
        protected void valueChanged(OrientationToRotationStrategy orientationToRotationStrategy, OrientationToRotationStrategy orientationToRotationStrategy2) {
            if (orientationToRotationStrategy != null) {
                orientationToRotationStrategy.removeListener(AbstractDockTitle.this.orientationListener);
                orientationToRotationStrategy.uninstall(AbstractDockTitle.this);
            }
            if (orientationToRotationStrategy2 != null) {
                orientationToRotationStrategy2.install(AbstractDockTitle.this);
                orientationToRotationStrategy2.addListener(AbstractDockTitle.this.orientationListener);
            }
            AbstractDockTitle.this.updateLabelRotation();
        }
    };
    private OrientationToRotationStrategyListener orientationListener = new OrientationToRotationStrategyListener(){

        public void rotationChanged(Dockable dockable, DockTitle dockTitle) {
            if (!(dockTitle != AbstractDockTitle.this && dockTitle != null || dockable != AbstractDockTitle.this.dockable && dockable != null)) {
                AbstractDockTitle.this.updateLabelRotation();
            }
        }
    };

    public AbstractDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this(dockable, dockTitleVersion, true);
    }

    public AbstractDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        this.init(dockable, dockTitleVersion, bl);
    }

    protected AbstractDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        this.dockable = dockable;
        this.showMiniButtons = bl;
        this.origin = dockTitleVersion;
        this.setLayout(null);
        this.add(this.label);
        this.setActive(false);
        if (bl) {
            this.itemPanel = new ButtonPanel(true){

                @Override
                protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
                    return AbstractDockTitle.this.createItemFor(dockAction, dockable);
                }
            };
            this.itemPanel.setOpaque(false);
            this.add(this.itemPanel);
        }
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy(){

            protected boolean accept(Component component) {
                return component != AbstractDockTitle.this && super.accept(component);
            }
        });
        this.setOpaque(false);
    }

    protected void addColor(AbstractDockColor abstractDockColor) {
        this.colors.add(abstractDockColor);
        if (this.bound) {
            abstractDockColor.connect(this.getDockable().getController());
        }
    }

    protected void removeColor(AbstractDockColor abstractDockColor) {
        this.colors.remove(abstractDockColor);
        abstractDockColor.connect(null);
    }

    protected void addFont(AbstractDockFont abstractDockFont) {
        this.fonts.add(abstractDockFont);
        if (this.bound) {
            abstractDockFont.connect(this.getDockable().getController());
        }
    }

    protected void removeFont(AbstractDockFont abstractDockFont) {
        this.fonts.remove(abstractDockFont);
        abstractDockFont.connect(null);
    }

    protected void addConditionalFont(String string, Path path, Condition condition, FontModifier fontModifier) {
        ConditionalFont conditionalFont = new ConditionalFont(string, path, condition, fontModifier);
        this.addFont(conditionalFont);
        if (this.conditionalFonts == null) {
            this.conditionalFonts = new ArrayList<ConditionalFont>();
        }
        this.conditionalFonts.add(conditionalFont);
        this.updateFonts();
    }

    protected void removeAllConditionalFonts() {
        if (this.conditionalFonts != null) {
            for (ConditionalFont conditionalFont : this.conditionalFonts) {
                this.removeFont(conditionalFont);
            }
            this.conditionalFonts = null;
            this.updateFonts();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.paintBackground(graphics, this);
        if (this.icon != null) {
            Insets insets = this.titleInsets();
            if (this.orientation.isVertical()) {
                int n = this.getWidth() - insets.left - insets.right;
                this.icon.paintIcon(this, graphics, insets.left + (n - this.icon.getIconWidth()) / 2, insets.top);
            } else {
                int n = this.getHeight() - insets.top - insets.bottom;
                this.icon.paintIcon(this, graphics, insets.left, insets.top + (n - this.icon.getIconHeight()) / 2);
            }
        }
    }

    public Rectangle getIconBounds() {
        if (this.icon == null) {
            return null;
        }
        Insets insets = this.titleInsets();
        if (this.orientation.isVertical()) {
            int n = this.getWidth() - insets.left - insets.right;
            return new Rectangle(insets.left + (n - this.icon.getIconWidth()) / 2, insets.top, this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        int n = this.getHeight() - insets.top - insets.bottom;
        return new Rectangle(insets.left, insets.top + (n - this.icon.getIconHeight()) / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
        this.revalidate();
        this.repaint();
    }

    protected Icon getIcon() {
        return this.icon;
    }

    protected void setText(String string) {
        this.label.setText(string);
        this.repaint();
    }

    protected String getText() {
        return this.label.getText();
    }

    protected void setTooltip(String string) {
        this.setToolTipText(string);
        this.label.setToolTipText(string);
        if (this.itemPanel != null) {
            this.itemPanel.setToolTipText(string);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        this.orientation = orientation;
        if (this.showMiniButtons) {
            this.itemPanel.setOrientation(orientation);
        }
        this.updateLabelRotation();
        this.revalidate();
    }

    private void updateLabelRotation() {
        this.label.setRotation(this.orientationConverter.getValue().convert(this.getOrientation(), this));
    }

    @Override
    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public DockTitleVersion getOrigin() {
        return this.origin;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.label != null) {
            this.label.setBackground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setFontModifier(FontModifier fontModifier) {
        this.label.setFontModifier(fontModifier);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.icon != null) {
            return new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        }
        Dimension dimension = this.getPreferredSize();
        int n = Math.min(dimension.width, dimension.height);
        return new Dimension(n, n);
    }

    protected Insets getInnerInsets() {
        if (this.getOrientation().isHorizontal()) {
            return DEFAULT_INSETS_HORIZONTAL;
        }
        return DEFAULT_INSETS_VERTICAL;
    }

    private Insets titleInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return this.getInnerInsets();
        }
        insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        Insets insets2 = this.getInnerInsets();
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        insets.left += insets2.left;
        insets.right += insets2.right;
        return insets;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Insets insets = this.titleInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        Dimension dimension = this.label.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            if (this.icon != null) {
                n += this.icon.getIconWidth();
                n3 -= this.icon.getIconWidth();
            }
            if (this.showMiniButtons && this.itemPanel.getItemCount() > 0) {
                int n5;
                Dimension[] dimensionArray = this.itemPanel.getPreferredSizes();
                int n6 = n3 - dimension.width;
                for (n5 = dimensionArray.length - 1; n5 > 0 && dimensionArray[n5].width > n6; --n5) {
                }
                this.itemPanel.setVisibleActions(n5);
                int n7 = dimensionArray[n5].width;
                int n8 = n3 - n7;
                this.label.setBounds(n, n2, n8, n4);
                this.itemPanel.setBounds(n + n8, n2, n3 - n8, n4);
            } else {
                this.label.setBounds(n, n2, n3, n4);
            }
        } else {
            if (this.icon != null) {
                n2 += this.icon.getIconWidth();
                n4 -= this.icon.getIconWidth();
            }
            if (this.showMiniButtons && this.itemPanel.getItemCount() > 0) {
                int n9;
                Dimension[] dimensionArray = this.itemPanel.getPreferredSizes();
                int n10 = n4 - dimension.height;
                for (n9 = dimensionArray.length - 1; n9 > 0 && dimensionArray[n9].height > n10; --n9) {
                }
                this.itemPanel.setVisibleActions(n9);
                int n11 = dimensionArray[n9].height;
                int n12 = n4 - n11;
                this.label.setBounds(n, n2, n3, n12);
                this.itemPanel.setBounds(n, n2 + n12, n3, n4 - n12);
            } else {
                this.label.setBounds(n, n2, n3, n4);
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.label.addMouseListener(mouseInputListener);
        this.label.addMouseMotionListener(mouseInputListener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
        this.label.removeMouseListener(mouseInputListener);
        this.label.removeMouseMotionListener(mouseInputListener);
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        boolean bl2 = this.getText() == null || this.getText().length() == 0;
        Rectangle rectangle = this.getIconBounds();
        if (rectangle != null && rectangle.contains(point)) {
            if (bl2) {
                int n = this.getWidth() * this.getHeight();
                if (this.itemPanel != null && this.showMiniButtons) {
                    n -= this.itemPanel.getWidth() * this.itemPanel.getHeight();
                }
                if (n <= 2 * rectangle.width * rectangle.height) {
                    return null;
                }
            }
            if (this.getOrientation().isHorizontal()) {
                return new Point(rectangle.x, rectangle.y + rectangle.height);
            }
            return new Point(rectangle.x + rectangle.width, rectangle.y);
        }
        return null;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockElement getElement() {
        return this.getDockable();
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public void changed(DockTitleEvent dockTitleEvent) {
        this.setActive(dockTitleEvent.isActive());
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getText() == null || this.getText().length() == 0 ? new Dimension(0, 0) : this.label.getPreferredSize();
        Insets insets = this.titleInsets();
        if (this.orientation.isHorizontal()) {
            int n = 0;
            int n2 = 0;
            if (this.icon != null) {
                n = this.icon.getIconWidth();
                n2 = this.icon.getIconHeight();
            }
            n2 = Math.max(n2, dimension.height);
            n += dimension.width;
            if (this.itemPanel != null) {
                Dimension dimension2 = this.itemPanel.getPreferredSize();
                n2 = Math.max(n2, dimension2.height);
                n += dimension2.width;
            }
            if (this.icon == null) {
                n = Math.max(n, 2 * n2);
            }
            dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        } else {
            int n = 0;
            int n3 = 0;
            if (this.icon != null) {
                n = this.icon.getIconWidth();
                n3 = this.icon.getIconHeight();
            }
            n = Math.max(n, dimension.width);
            n3 += dimension.height;
            if (this.itemPanel != null) {
                Dimension dimension3 = this.itemPanel.getPreferredSize();
                n = Math.max(n, dimension3.width);
                n3 += dimension3.height;
            }
            if (this.icon == null) {
                n3 = Math.max(n3, 2 * n);
            }
            dimension = new Dimension(n + insets.left + insets.right, n3 + insets.top + insets.bottom);
        }
        if (dimension.width < 10) {
            dimension.width = 10;
        }
        if (dimension.height < 10) {
            dimension.height = 10;
        }
        return dimension;
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ViewTarget.TITLE, dockable);
    }

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return dockable.getGlobalActionOffers();
    }

    @Override
    public void bind() {
        if (this.bound) {
            throw new IllegalArgumentException("Do not call bound twice!");
        }
        this.bound = true;
        if (this.showMiniButtons) {
            this.itemPanel.set(this.dockable, this.getActionSourceFor(this.dockable));
        }
        this.dockable.addDockableListener(this.listener);
        DockController dockController = this.dockable.getController();
        if (dockController != null) {
            for (AbstractDockColor abstractUIValue : this.colors) {
                abstractUIValue.connect(dockController);
            }
            for (AbstractDockFont abstractDockFont : this.fonts) {
                abstractDockFont.connect(dockController);
            }
            this.orientationConverter.setProperties(dockController);
        }
        this.updateText();
        this.updateIcon();
        this.updateTooltip();
        this.revalidate();
    }

    @Override
    public void unbind() {
        if (!this.bound) {
            throw new IllegalArgumentException("Do not call unbind twice");
        }
        this.bound = false;
        this.dockable.removeDockableListener(this.listener);
        if (this.showMiniButtons) {
            this.itemPanel.set(null);
        }
        for (AbstractDockColor abstractUIValue : this.colors) {
            abstractUIValue.connect(null);
        }
        for (AbstractDockFont abstractDockFont : this.fonts) {
            abstractDockFont.connect(null);
        }
        this.orientationConverter.setProperties((DockProperties)null);
        this.setText("");
        this.setIcon(null);
        this.setTooltip(null);
    }

    protected void updateIcon() {
        this.setIcon(this.dockable.getTitleIcon());
    }

    protected void updateText() {
        this.setText(this.dockable.getTitleText());
    }

    protected void updateTooltip() {
        this.setTooltip(this.dockable.getTitleToolTip());
    }

    public boolean isBound() {
        return this.bound;
    }

    protected void updateFonts() {
        if (this.conditionalFonts != null) {
            FontModifier fontModifier = null;
            for (ConditionalFont conditionalFont : this.conditionalFonts) {
                if (!conditionalFont.getState()) continue;
                fontModifier = (FontModifier)conditionalFont.value();
                break;
            }
            this.setFontModifier(fontModifier);
        }
    }

    private class Listener
    implements DockableListener,
    DockHierarchyListener {
        private Listener() {
        }

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            AbstractDockTitle.this.updateIcon();
            AbstractDockTitle.this.updateText();
        }

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            AbstractDockTitle.this.updateIcon();
            AbstractDockTitle.this.updateText();
        }

        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            AbstractDockTitle.this.updateTooltip();
        }

        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }

        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            DockController dockController = dockHierarchyEvent.getDockable().getController();
            for (AbstractDockColor abstractDockColor : AbstractDockTitle.this.colors) {
                abstractDockColor.connect(dockController);
            }
        }

        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }
    }

    private class ConditionalFont
    extends TitleFont {
        private Condition condition;

        public ConditionalFont(String string, Path path, Condition condition, FontModifier fontModifier) {
            super(string, AbstractDockTitle.this, path, fontModifier);
            this.condition = condition;
        }

        public boolean getState() {
            return this.condition.getState();
        }

        protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
            AbstractDockTitle.this.updateFonts();
        }
    }
}

