/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.util.MouseOverListener;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Path;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractBubbleDockTitle
extends AbstractDockTitle {
    protected static final String ANIMATION_KEY_TEXT = "text";
    protected static final String ANIMATION_KEY_BACKGROUND_TOP = "top";
    protected static final String ANIMATION_KEY_BACKGROUND_BOTTOM = "top";
    private BubbleColorAnimation animation;
    private MouseOverListener mouseover;
    private int arc = 16;
    private List<BubbleTitleColor> colors = new ArrayList<BubbleTitleColor>();

    public AbstractBubbleDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this(dockable, dockTitleVersion, true);
    }

    public AbstractBubbleDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        this.init(dockable, dockTitleVersion, bl);
    }

    protected AbstractBubbleDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        super.init(dockable, dockTitleVersion, bl);
        this.setOpaque(false);
        this.initAnimation();
        this.mouseover = new MouseOverListener(this.getComponent()){

            protected void changed() {
                AbstractBubbleDockTitle.this.updateAnimation();
            }
        };
    }

    public boolean isMouseOver() {
        return this.mouseover == null ? false : this.mouseover.isMouseOver();
    }

    protected void addColor(String string, Path path, Color color) {
        BubbleTitleColor bubbleTitleColor = new BubbleTitleColor(string, path, color);
        this.colors.add(bubbleTitleColor);
        this.addColor(bubbleTitleColor);
    }

    private void initAnimation() {
        this.animation = new BubbleColorAnimation();
        this.updateAnimation();
        this.animation.addTask(new Runnable(){

            public void run() {
                AbstractBubbleDockTitle.this.pulse();
            }
        });
        this.setForeground(this.animation.getColor(ANIMATION_KEY_TEXT));
    }

    public void bind() {
        super.bind();
        this.animation.kick();
    }

    public void setActive(boolean bl) {
        if (this.isActive() != bl) {
            super.setActive(bl);
            this.updateAnimation();
        }
    }

    protected abstract void updateAnimation();

    protected void updateAnimation(String string, String string2) {
        for (BubbleTitleColor bubbleTitleColor : this.colors) {
            if (!string2.equals(bubbleTitleColor.getId())) continue;
            this.animation.putColor(string, bubbleTitleColor.color());
            break;
        }
    }

    protected void pulse() {
        this.setForeground(this.animation.getColor(ANIMATION_KEY_TEXT));
        this.repaint();
    }

    protected Insets getInnerInsets() {
        int n = this.arc / 4;
        switch (this.getOrientation()) {
            case EAST_SIDED: {
                return new Insets(n, n / 2, n, n);
            }
            case FREE_HORIZONTAL: {
                return new Insets(n, n, n, n);
            }
            case FREE_VERTICAL: {
                return new Insets(n, n, n, n);
            }
            case NORTH_SIDED: {
                return new Insets(n, n, n / 2, n);
            }
            case SOUTH_SIDED: {
                return new Insets(n / 2, n, n, n);
            }
            case WEST_SIDED: {
                return new Insets(n, n, n, n / 2);
            }
        }
        return super.getInnerInsets();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Insets insets = this.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        if ((rectangle = graphics.getClipBounds()) == null) {
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        if (this.getOrientation().isHorizontal()) {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, n4 / 2, Color.WHITE));
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
            graphics2D.setClip(0, 0, n3, n4 / 2);
            graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), n3 / 2, 0.0f, Color.WHITE));
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
            graphics2D.setClip(0, 0, n3 / 2, n4);
            graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.drawRoundRect(graphics2D, n, n2, n3, n4);
        graphics2D.dispose();
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = this.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        Color color = this.animation.getColor("top");
        Color color2 = this.animation.getColor("top");
        if (color != null && color2 != null) {
            if (this.getOrientation().isHorizontal()) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, n4, color2));
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, n3, 0.0f, color2));
            }
            this.drawRoundRect(graphics2D, n, n2, n3, n4);
        }
        graphics2D.dispose();
    }

    private void drawRoundRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        switch (this.getOrientation()) {
            case FREE_HORIZONTAL: 
            case FREE_VERTICAL: {
                graphics2D.fillRoundRect(n, n2, n3, n4, this.arc, this.arc);
                break;
            }
            case EAST_SIDED: {
                graphics2D.fillRoundRect(n - this.arc, n2, n3 + this.arc, n4, this.arc, this.arc);
                break;
            }
            case NORTH_SIDED: {
                graphics2D.fillRoundRect(n, n2, n3, n4 + this.arc, this.arc, this.arc);
                break;
            }
            case SOUTH_SIDED: {
                graphics2D.fillRoundRect(n, n2 - this.arc, n3, n4 + this.arc, this.arc, this.arc);
                break;
            }
            case WEST_SIDED: {
                graphics2D.fillRoundRect(n, n2, n3 + this.arc, n4, this.arc, this.arc);
            }
        }
    }

    private class BubbleTitleColor
    extends TitleColor {
        public BubbleTitleColor(String string, Path path, Color color) {
            super(string, path, AbstractBubbleDockTitle.this, color);
        }

        protected void changed(Color color, Color color2) {
            AbstractBubbleDockTitle.this.updateAnimation();
        }
    }
}

