/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeElement;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.station.split.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizeNode<T>
extends ResizeElement<T> {
    private Node node;
    private double dividerSize;
    private ResizeElement<T>[] children = new ResizeElement[2];

    public ResizeNode(LockedResizeLayoutManager<T> lockedResizeLayoutManager, ResizeElement<T> resizeElement, Node node) {
        super(resizeElement, lockedResizeLayoutManager);
        this.node = node;
        this.children[0] = lockedResizeLayoutManager.toElement(this, node.getLeft());
        this.children[1] = lockedResizeLayoutManager.toElement(this, node.getRight());
    }

    public Node getNode() {
        return this.node;
    }

    public ResizeElement<T> getLeft() {
        return this.children[0];
    }

    public ResizeElement<T> getRight() {
        return this.children[1];
    }

    @Override
    protected ResizeElement<T>[] getChildren() {
        return this.children;
    }

    @Override
    public void prepareResize() {
        super.prepareResize();
        this.dividerSize = this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? this.getDividerWidth() : this.getDividerHeight();
    }

    public double getDividerWidth() {
        return (double)this.node.getStation().getDividerSize() / this.node.getRoot().getWidthFactor();
    }

    public double getDividerHeight() {
        return (double)this.node.getStation().getDividerSize() / this.node.getRoot().getHeightFactor();
    }

    public double getNewDividerSize() {
        if (this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            return this.getDividerWidth();
        }
        return this.getDividerHeight();
    }

    public double getOldDividerSize() {
        return this.dividerSize;
    }

    @Override
    protected ResizeRequest createRequest() {
        boolean bl;
        ResizeRequest resizeRequest = this.getLeft().getRequest();
        ResizeRequest resizeRequest2 = this.getRight().getRequest();
        boolean bl2 = bl = this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL;
        if (bl) {
            return this.getLayout().getConflictResolver().requestHorizontal(resizeRequest, resizeRequest2, this);
        }
        return this.getLayout().getConflictResolver().requestVertical(resizeRequest, resizeRequest2, this);
    }

    @Override
    public void adapt(double d, double d2) {
        boolean bl;
        ResizeRequest resizeRequest = this.getLeft().getRequest();
        ResizeRequest resizeRequest2 = this.getRight().getRequest();
        boolean bl2 = bl = this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL;
        if (bl) {
            if (resizeRequest != null && resizeRequest.getFractionWidth() == -1) {
                resizeRequest = null;
            }
            if (resizeRequest2 != null && resizeRequest2.getFractionWidth() == -1) {
                resizeRequest2 = null;
            }
        } else {
            if (resizeRequest != null && resizeRequest.getFractionHeight() == -1) {
                resizeRequest = null;
            }
            if (resizeRequest2 != null && resizeRequest2.getFractionHeight() == -1) {
                resizeRequest2 = null;
            }
        }
        if (resizeRequest == null && resizeRequest2 == null) {
            if (bl) {
                this.getLeft().adapt(d * this.node.getDivider(), d2);
                this.getRight().adapt(d * (1.0 - this.node.getDivider()), d2);
            } else {
                this.getLeft().adapt(d, d2 * this.node.getDivider());
                this.getRight().adapt(d2, d2 * (1.0 - this.node.getDivider()));
            }
        } else if (bl) {
            double d3;
            double d4;
            double d5;
            double d6 = this.node.getDivider();
            double d7 = this.node.getWidth();
            double d8 = this.getDividerWidth();
            double d9 = d7 * d6 - d8 / 2.0;
            double d10 = d7 * (1.0 - d6) - d8 / 2.0;
            d7 += d;
            if (resizeRequest2 == null) {
                d5 = resizeRequest.getDeltaWidth() / (double)resizeRequest.getFractionWidth();
                d4 = d7 <= 0.0 ? 0.0 : (d5 -= d * d6) / d7;
            } else if (resizeRequest == null) {
                d5 = resizeRequest2.getDeltaWidth() / (double)resizeRequest2.getFractionWidth();
                d4 = d7 <= 0.0 ? 0.0 : -(d5 -= d * (1.0 - d6)) / d7;
            } else {
                d5 = resizeRequest.getDeltaWidth() / (double)resizeRequest.getFractionWidth();
                d3 = resizeRequest2.getDeltaWidth() / (double)resizeRequest2.getFractionWidth();
                double d11 = d7 <= 0.0 ? 0.0 : (d5 -= d * d6) / d7;
                double d12 = d7 <= 0.0 ? 0.0 : -(d3 -= d * (1.0 - d6)) / d7;
                d4 = this.getLayout().getConflictResolver().resolveHorizontal(this, resizeRequest, d11, resizeRequest2, d12);
            }
            d6 += d4;
            d6 = Math.min(1.0, Math.max(0.0, d6));
            this.node.setDivider(d6);
            d5 = d7 * d6 - d8 / 2.0;
            d3 = d7 * (1.0 - d6) - d8 / 2.0;
            this.getLeft().adapt(d5 - d9, d2);
            this.getRight().adapt(d3 - d10, d2);
        } else {
            double d13;
            double d14;
            double d15;
            double d16 = this.node.getDivider();
            double d17 = this.node.getHeight();
            double d18 = this.getDividerHeight();
            double d19 = d17 * d16 - d18 / 2.0;
            double d20 = d17 * (1.0 - d16) - d18 / 2.0;
            d17 += d2;
            if (resizeRequest2 == null) {
                d15 = resizeRequest.getDeltaHeight() / (double)resizeRequest.getFractionHeight();
                d14 = d17 <= 0.0 ? 0.0 : (d15 -= d2 * d16) / d17;
            } else if (resizeRequest == null) {
                d15 = resizeRequest2.getDeltaHeight() / (double)resizeRequest2.getFractionHeight();
                d14 = d17 <= 0.0 ? 0.0 : -(d15 -= d2 * (1.0 - d16)) / d17;
            } else {
                d15 = resizeRequest.getDeltaHeight() / (double)resizeRequest.getFractionHeight();
                d13 = resizeRequest2.getDeltaHeight() / (double)resizeRequest2.getFractionHeight();
                double d21 = d17 <= 0.0 ? 0.0 : (d15 -= d2 * d16) / d17;
                double d22 = d17 <= 0.0 ? 0.0 : -(d13 -= d2 * (1.0 - d16)) / d17;
                d14 = this.getLayout().getConflictResolver().resolveVertical(this, resizeRequest, d21, resizeRequest2, d22);
            }
            d16 += d14;
            d16 = Math.min(1.0, Math.max(0.0, d16));
            this.node.setDivider(d16);
            d15 = d17 * d16 - d18 / 2.0;
            d13 = d17 * (1.0 - d16) - d18 / 2.0;
            this.getLeft().adapt(d, d15 - d19);
            this.getRight().adapt(d, d13 - d20);
        }
    }
}

