/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MinimizedMode;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationSettingConverter
implements ModeSettingsConverter<Location, Location> {
    private PropertyTransformer transformer = new PropertyTransformer();

    public void addFactory(DockablePropertyFactory dockablePropertyFactory) {
        this.transformer.addFactory(dockablePropertyFactory);
    }

    @Override
    public Location convertToSetting(Location location) {
        return location;
    }

    @Override
    public Location convertToWorld(Location location) {
        return location;
    }

    @Override
    public void writeProperty(Location location, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeUTF(location.getMode().toString());
        dataOutputStream.writeUTF(location.getRoot());
        this.transformer.write(location.getLocation(), dataOutputStream);
    }

    @Override
    public Location readProperty(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        Path path = null;
        if (bl) {
            path = new Path(dataInputStream.readUTF());
        }
        String string = dataInputStream.readUTF();
        DockableProperty dockableProperty = this.transformer.read(dataInputStream);
        if (!bl) {
            path = this.guessMode(dockableProperty);
        }
        return new Location(path, string, dockableProperty);
    }

    private Path guessMode(DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            return MinimizedMode.IDENTIFIER;
        }
        if (dockableProperty instanceof ScreenDockProperty) {
            return ExternalizedMode.IDENTIFIER;
        }
        return NormalMode.IDENTIFIER;
    }

    @Override
    public void writePropertyXML(Location location, XElement xElement) {
        xElement.addElement("mode").setString(location.getMode().toString());
        xElement.addElement("root").setString(location.getRoot());
        this.transformer.writeXML(location.getLocation(), xElement.addElement("location"));
    }

    @Override
    public Location readPropertyXML(XElement xElement) {
        XElement xElement2 = xElement.getElement("mode");
        Path path = null;
        if (xElement2 != null) {
            path = new Path(xElement2.getString());
        }
        String string = xElement.getElement("root").getString();
        DockableProperty dockableProperty = this.transformer.readXML(xElement.getElement("location"));
        if (path == null) {
            path = this.guessMode(dockableProperty);
        }
        return new Location(path, string, dockableProperty);
    }
}

