/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.facile.mode.MinimizedMode;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLocationModeSettings<B>
extends ModeSettings<Location, B> {
    private Map<String, B> lastMaximizedLocation;
    private Map<String, String> lastMaximizedMode;
    private static final String MINIMIZED = "mini";
    private static final String MAXIMIZED = "maxi";
    private static final String NORMALIZED = "normal";
    private static final String EXTERNALIZED = "extern";

    public CLocationModeSettings(ModeSettingsConverter<Location, B> modeSettingsConverter) {
        super(modeSettingsConverter);
    }

    public void rescue(CMaximizedMode cMaximizedMode) {
        if (this.lastMaximizedLocation != null) {
            Object object;
            MaximizedModeSetting maximizedModeSetting = new MaximizedModeSetting();
            HashMap<String, Path> hashMap = new HashMap<String, Path>();
            for (Map.Entry<String, String> entry : this.lastMaximizedMode.entrySet()) {
                String object2 = entry.getValue();
                object = this.resuceMode(object2);
                if (object == null) continue;
                hashMap.put((String)entry.getKey(), (Path)object);
            }
            HashMap hashMap2 = new HashMap();
            for (Map.Entry entry : this.lastMaximizedLocation.entrySet()) {
                object = (Location)this.getConverter().convertToWorld(entry.getValue());
                hashMap2.put(entry.getKey(), object);
            }
            hashMap2.keySet().retainAll(hashMap.keySet());
            hashMap.keySet().retainAll(hashMap2.keySet());
            maximizedModeSetting.setLastMaximizedLocation(hashMap2);
            maximizedModeSetting.setLastMaximizedMode(hashMap);
            cMaximizedMode.readSetting(maximizedModeSetting);
        }
    }

    @Override
    protected Path resuceMode(String string) {
        if (MINIMIZED.equals(string)) {
            return MinimizedMode.IDENTIFIER;
        }
        if (NORMALIZED.equals(string)) {
            return NormalMode.IDENTIFIER;
        }
        if (EXTERNALIZED.equals(string)) {
            return ExternalizedMode.IDENTIFIER;
        }
        if (MAXIMIZED.equals(string)) {
            return MaximizedMode.IDENTIFIER;
        }
        return null;
    }

    @Override
    protected void rescueSettings(DataInputStream dataInputStream, Version version) throws IOException {
        if (version.compareTo(Version.VERSION_1_0_7) < 0) {
            if (dataInputStream.readBoolean()) {
                dataInputStream.readUTF();
            }
            if (dataInputStream.readBoolean()) {
                this.getConverter().readProperty(dataInputStream);
            }
        } else if (version.compareTo(Version.VERSION_1_0_7) == 0) {
            String string;
            String string2;
            int n;
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            int n2 = dataInputStream.readInt();
            for (n = 0; n < n2; ++n) {
                string2 = dataInputStream.readUTF();
                string = dataInputStream.readUTF();
                this.lastMaximizedMode.put(string2, string);
            }
            n2 = dataInputStream.readInt();
            for (n = 0; n < n2; ++n) {
                string2 = dataInputStream.readUTF();
                string = this.getConverter().readProperty(dataInputStream);
                this.lastMaximizedLocation.put(string2, string);
            }
        }
    }

    @Override
    protected void rescueSettings(XElement xElement) {
        XElement xElement2 = xElement.getElement("states");
        if (xElement2 != null) {
            this.lastMaximizedLocation = new HashMap<String, B>();
            this.lastMaximizedMode = new HashMap<String, String>();
            XElement xElement3 = xElement.getElement("maximized");
            if (xElement3 != null) {
                for (XElement xElement4 : xElement3.getElements("item")) {
                    XElement xElement5;
                    String string = xElement4.getString("id");
                    XElement xElement6 = xElement4.getElement("mode");
                    if (xElement6 != null) {
                        this.lastMaximizedMode.put(string, xElement6.getString());
                    }
                    if ((xElement5 = xElement4.getElement("location")) == null) continue;
                    XElement xElement7 = xElement5.copy();
                    xElement7.addElement("mode").setString(MaximizedMode.IDENTIFIER.toString());
                    this.lastMaximizedLocation.put(string, this.getConverter().readPropertyXML(xElement7));
                }
            }
        }
    }
}

