/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.codegen;

import at.ac.ait.speedr.codegen.FilterExpressionRCodeGen;
import at.ac.ait.speedr.codegen.FilterFunctionCodeGen;
import at.ac.ait.speedr.importwizard.steps.DataImportPanelUserActionListener;
import at.ac.ait.speedr.table.RDate;
import at.ac.ait.speedr.table.RPOSIXct;
import at.ac.arcs.tablefilter.events.FilterEvent;
import at.ac.arcs.tablefilter.events.FilterListener;
import at.ac.arcs.tablefilter.filtermodel.DateFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.NumericFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.info.FilterColumnInfo;
import at.ac.arcs.tablefilter.filtermodel.info.FilterInfo;
import at.ac.arcs.tablefilter.filtermodel.info.FilterRowInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableModel;
import org.ait.table.filter.FilterExpressionLexer;
import org.ait.table.filter.FilterExpressionParser;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class ImportAndFilterCodeGen
implements FilterListener,
DataImportPanelUserActionListener {
    private static final Logger logger = Logger.getLogger(ImportAndFilterCodeGen.class.getName());
    private static StringTemplateGroup filter_stg;
    private static StringTemplateGroup import_stg;
    private static StringTemplateGroup importandfilter_stg;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent;
    private StringTemplate importanyfunctionST;
    private StringTemplate fileST;
    private StringTemplate delimiterST;
    private StringTemplate textqualifierST;
    private StringTemplate rowstartST;
    private StringTemplate rowendST;
    private StringTemplate colstartST;
    private StringTemplate colendST;
    private StringTemplate hasRowNamesST;
    private StringTemplate rowNamesColumnIndexST;
    private StringTemplate hasColumnNamesST;
    private StringTemplate columnNamesRowIndexST;
    private StringTemplate colClassesST;
    private String variablename = "temp";
    private String filterFunctionName = "temp_filter";
    private TableModel model;
    private String importcode = "";
    private String filtercode = "";
    private boolean hasRowNames = false;
    private int rowNamesColumnIndex = 1;
    private int rowstartIndex = 1;
    private int rowendIndex = 0;
    private int colstartIndex = 1;
    private int colendIndex = 0;
    private String[] colClasses;
    private HashMap<Integer, HashMap<Integer, Object>> cellUpdates = new HashMap();

    public ImportAndFilterCodeGen() throws IOException {
        if (importandfilter_stg == null) {
            InputStreamReader r = new InputStreamReader(ImportAndFilterCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/ImportCodeGen.stg"));
            import_stg = new StringTemplateGroup((Reader)r);
            r.close();
            r = new InputStreamReader(ImportAndFilterCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/RCodeGen.stg"));
            filter_stg = new StringTemplateGroup((Reader)r);
            r.close();
            r = new InputStreamReader(ImportAndFilterCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/ImportAndFilterCodeGen.stg"));
            importandfilter_stg = new StringTemplateGroup((Reader)r);
            r.close();
        }
    }

    private void setFiltercode() {
        this.importanyfunctionST = import_stg.getInstanceOf("importany");
        this.importanyfunctionST.setAttribute("varname", (Object)this.variablename);
        if (this.fileST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.fileST);
        }
        if (this.delimiterST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.delimiterST);
        }
        if (this.textqualifierST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.textqualifierST);
        }
        if (this.rowstartST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.rowstartST);
        }
        if (this.rowendST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.rowendST);
        }
        if (this.colstartST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.colstartST);
        }
        if (this.colendST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.colendST);
        }
        if (this.hasRowNamesST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.hasRowNamesST);
        }
        if (this.rowNamesColumnIndexST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.rowNamesColumnIndexST);
        }
        if (this.hasColumnNamesST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.hasColumnNamesST);
        }
        if (this.columnNamesRowIndexST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.columnNamesRowIndexST);
        }
        if (this.colClassesST != null) {
            this.importanyfunctionST.setAttribute("params", (Object)this.colClassesST);
        }
        this.importcode = this.importanyfunctionST.toString();
    }

    public String getImportAndFilterCode() {
        this.setFiltercode();
        StringTemplate t = importandfilter_stg.getInstanceOf("importandfilter");
        t.setAttribute("params", (Object)this.importcode);
        StringTemplate _cellUpdates = this.generateCellUpdates();
        if (_cellUpdates != null) {
            t.setAttribute("params", (Object)_cellUpdates);
        }
        t.setAttribute("params", (Object)this.filtercode);
        if (this.filtercode != null && !this.filtercode.equals("")) {
            t.setAttribute("params", (Object)(this.variablename + "<-" + this.getFilterFunctionName() + "(" + this.variablename + ")"));
        }
        return t.toString();
    }

    public void filterChanged(FilterEvent event) {
        FilterRowInfo[] filterRows;
        StringTemplate filterfunction = filter_stg.getInstanceOf("filterfunction");
        filterfunction.setAttribute("functionname", (Object)this.getFilterFunctionName());
        FilterInfo filterInfo = event.getFilterInfo();
        for (FilterRowInfo filterRowInfo : filterRows = filterInfo.getFilterRows()) {
            StringTemplate filterlevel = filter_stg.getInstanceOf("filterlevel");
            List columns = filterRowInfo.getColumns();
            if (columns.isEmpty()) {
                filterfunction.setAttribute("filterlevels", (Object)"(TRUE)");
                continue;
            }
            for (FilterColumnInfo filterColumnInfo : columns) {
                String exp = filterColumnInfo.getExpression();
                try {
                    ANTLRStringStream input = new ANTLRStringStream(exp);
                    FilterExpressionLexer lexer = new FilterExpressionLexer((CharStream)input);
                    CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                    FilterExpressionParser parser = new FilterExpressionParser((TokenStream)tokens);
                    lexer.setNumberColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof NumericFilterDevice);
                    parser.setNumberColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof NumericFilterDevice);
                    parser.setDateColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof DateFilterDevice);
                    FilterExpressionParser.formula_return formula = parser.formula();
                    CommonTree tree = (CommonTree)formula.getTree();
                    CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                    nodes.setTokenStream((TokenStream)tokens);
                    FilterExpressionRCodeGen rcodegen = new FilterExpressionRCodeGen((TreeNodeStream)nodes);
                    int col = filterColumnInfo.getColumn();
                    if (col == 0 && this.model.getColumnName(0).equals("row.names")) {
                        rcodegen.setHasRowNames(true);
                        rcodegen.setColumnIndex("rownames(x)");
                    } else {
                        rcodegen.setDataframe(true);
                        rcodegen.setDataframeColumnIndex(this.model.getColumnName(col));
                        if (this.model.getColumnClass(col) == RPOSIXct.class) {
                            rcodegen.setPOSIXct(true);
                        }
                    }
                    rcodegen.setTemplateLib(filter_stg);
                    FilterExpressionRCodeGen.rcode_return rcode = rcodegen.rcode();
                    filterlevel.setAttribute("selectors", (Object)rcode.st);
                }
                catch (RecognitionException recognitionException) {
                    Logger.getLogger(FilterFunctionCodeGen.class.getName()).log(Level.SEVERE, "Can't parse the expression: " + exp, recognitionException);
                }
            }
            filterfunction.setAttribute("filterlevels", (Object)filterlevel);
        }
        this.filtercode = filterfunction.toString();
        this.fireStateChanged();
    }

    private String getFilterFunctionName() {
        return this.filterFunctionName;
    }

    private void setFilterFunctionName() {
        this.filterFunctionName = this.filterFunctionName = this.variablename + "_filter";
    }

    public void setFile(String path) {
        this.fileST = import_stg.getInstanceOf("file");
        this.fileST.setAttribute("value", (Object)path);
    }

    public void separatorChanged(String newvalue) {
        this.delimiterST = import_stg.getInstanceOf("separator");
        this.delimiterST.setAttribute("value", (Object)newvalue);
        this.cellUpdates.clear();
        this.fireStateChanged();
    }

    public void quoteChanged(String newvalue) {
        this.cellUpdates.clear();
        if (newvalue == null) {
            this.textqualifierST = null;
        } else {
            this.textqualifierST = import_stg.getInstanceOf("quote");
            this.textqualifierST.setAttribute("value", (Object)newvalue);
            this.fireStateChanged();
        }
    }

    public void rowStartChanged(int newvalue) {
        this.rowstartIndex = newvalue;
        this.rowstartST = import_stg.getInstanceOf("rowstart");
        this.rowstartST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void rowEndChange(int newvalue) {
        this.rowendIndex = newvalue;
        this.rowendST = import_stg.getInstanceOf("rowend");
        this.rowendST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void colStartChanged(int newvalue) {
        this.colstartIndex = newvalue;
        this.colstartST = import_stg.getInstanceOf("colstart");
        this.colstartST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void colEndChange(int newvalue) {
        this.colendIndex = newvalue;
        this.colendST = import_stg.getInstanceOf("colend");
        this.colendST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void hasColumnNamesChanged(Boolean newvalue) {
        this.hasColumnNamesST = import_stg.getInstanceOf("hasColumnNames");
        this.hasColumnNamesST.setAttribute("value", (Object)newvalue.toString().toUpperCase());
        this.fireStateChanged();
    }

    public void columnNamesRowIndexChanged(int newvalue) {
        this.columnNamesRowIndexST = import_stg.getInstanceOf("columnNamesRowIndex");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "new columnNamesRowIndex = {0}", newvalue);
        }
        this.columnNamesRowIndexST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void hasRowNamesChanged(Boolean newvalue) {
        this.hasRowNames = newvalue;
        this.hasRowNamesST = import_stg.getInstanceOf("hasRowNames");
        this.hasRowNamesST.setAttribute("value", (Object)newvalue.toString().toUpperCase());
        this.fireStateChanged();
    }

    public void rowNamesNoChanged(int newvalue) {
        this.rowNamesColumnIndex = newvalue;
        this.rowNamesColumnIndexST = import_stg.getInstanceOf("rowNamesColumnIndex");
        this.rowNamesColumnIndexST.setAttribute("value", newvalue);
        this.fireStateChanged();
    }

    public void variableNameChanged(String newvalue) {
        String oldFilterFunctionName = this.getFilterFunctionName();
        this.variablename = newvalue;
        this.setFilterFunctionName();
        String newFilterFunctionName = this.getFilterFunctionName();
        this.filtercode = this.filtercode.replaceFirst(oldFilterFunctionName, newFilterFunctionName);
        this.fireStateChanged();
    }

    public void tableCellValueChanged(Object aValue, int rowIndex, int columnIndex) {
        Integer realRowIndex = this.rowstartIndex + rowIndex;
        Integer realColumnIndex = this.hasRowNames && columnIndex == 0 ? Integer.valueOf(this.rowNamesColumnIndex) : Integer.valueOf(this.colstartIndex + columnIndex);
        if (!this.cellUpdates.containsKey(realRowIndex)) {
            this.cellUpdates.put(realRowIndex, new HashMap());
        }
        this.cellUpdates.get(realRowIndex).put(realColumnIndex, aValue);
        this.fireStateChanged();
    }

    public void colClassesChanged(String[] classes) {
        this.colClasses = classes;
        this.colClassesST = import_stg.getInstanceOf("colClasses");
        this.colClassesST.setAttribute("classes", (Object)this.colClasses);
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void setModel(TableModel tablemodel) {
        this.model = tablemodel;
        this.cellUpdates.clear();
    }

    private StringTemplate generateCellUpdates() {
        StringTemplate updates = null;
        for (Integer rowIndex : this.cellUpdates.keySet()) {
            if (!this.isRowInTheRange(rowIndex)) continue;
            if (updates == null) {
                updates = import_stg.getInstanceOf("cellUpdates");
            }
            for (Integer columnIndex : this.cellUpdates.get(rowIndex).keySet()) {
                if (!this.isColumnInTheRange(columnIndex)) continue;
                StringTemplate update = this.hasRowNames && columnIndex == this.rowNamesColumnIndex ? this.createRowNamesUpdateST(rowIndex) : this.createCellUpdateST(rowIndex, columnIndex);
                updates.setAttribute("allCellUpdates", (Object)update);
            }
        }
        return updates;
    }

    private boolean isRowInTheRange(int rowIndex) {
        return rowIndex >= this.rowstartIndex && (rowIndex <= this.rowendIndex || this.rowendIndex == 0);
    }

    private boolean isColumnInTheRange(int columnIndex) {
        if (this.hasRowNames && columnIndex == this.rowNamesColumnIndex) {
            return true;
        }
        if (this.hasRowNames) {
            if (columnIndex < this.rowNamesColumnIndex) {
                return columnIndex >= this.colstartIndex && (this.colendIndex == 0 || columnIndex - 1 <= this.colendIndex);
            }
            return columnIndex >= this.colstartIndex + 1 && (this.colendIndex == 0 || columnIndex - 1 <= this.colendIndex);
        }
        return columnIndex >= this.colstartIndex && (columnIndex <= this.colendIndex || this.colendIndex == 0);
    }

    private StringTemplate createCellUpdateST(Integer rowIndex, Integer columnIndex) {
        StringTemplate update = import_stg.getInstanceOf("cellUpdate");
        update.setAttribute("varname", (Object)this.variablename);
        if (this.cellUpdates.get(rowIndex).get(columnIndex) == null || this.cellUpdates.get(rowIndex).get(columnIndex).equals("")) {
            update.setAttribute("value", (Object)"NA");
        } else if (this.cellUpdates.get(rowIndex).get(columnIndex) instanceof Number || this.cellUpdates.get(rowIndex).get(columnIndex) instanceof RDate || this.cellUpdates.get(rowIndex).get(columnIndex) instanceof RPOSIXct) {
            update.setAttribute("value", this.cellUpdates.get(rowIndex).get(columnIndex));
        } else {
            update.setAttribute("value", (Object)("\"" + this.cellUpdates.get(rowIndex).get(columnIndex) + "\""));
        }
        update.setAttribute("rowIndex", rowIndex - this.rowstartIndex + 1);
        if (this.hasRowNames && columnIndex > this.rowNamesColumnIndex) {
            update.setAttribute("columnIndex", columnIndex - this.colstartIndex);
        } else {
            update.setAttribute("columnIndex", columnIndex - this.colstartIndex + 1);
        }
        return update;
    }

    private StringTemplate createRowNamesUpdateST(int rowIndex) {
        StringTemplate update = import_stg.getInstanceOf("rownameUpdate");
        update.setAttribute("varname", (Object)this.variablename);
        update.setAttribute("rowIndex", rowIndex - this.rowstartIndex + 1);
        update.setAttribute("value", (Object)("\"" + this.cellUpdates.get(rowIndex).get(this.rowNamesColumnIndex) + "\""));
        return update;
    }

    public void colClassChanged(int columnIndex, String clazz) {
        Integer realColumnIndex = this.hasRowNames && columnIndex == 0 ? Integer.valueOf(this.rowNamesColumnIndex) : Integer.valueOf(this.colstartIndex + columnIndex);
        ArrayList<Integer> todelete = new ArrayList<Integer>();
        for (Integer rowIndex : this.cellUpdates.keySet()) {
            this.cellUpdates.get(rowIndex).remove(realColumnIndex);
            if (!this.cellUpdates.get(rowIndex).isEmpty()) continue;
            todelete.add(rowIndex);
        }
        for (Integer row : todelete) {
            this.cellUpdates.remove(row);
        }
        this.fireStateChanged();
    }
}

