% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spectra.R
\name{i_verify_path_and_format}
\alias{i_verify_path_and_format}
\title{Internal function to verify file paths and format}
\usage{
i_verify_path_and_format(
  path,
  format = NULL,
  exclude_if_matches = NULL,
  ignore_extension = FALSE
)
}
\arguments{
\item{path}{Path to directory or input files}

\item{format}{File format. Defaults to NULL so spectrolab tries to guess it
from the file name. Alternatively, use "asd" for ASD; "sig"
for SVC (Spectra Vista); or "sed" for PSR (Spectral Evolution)}

\item{exclude_if_matches}{excludes files that match this regular expression.
Example: "BAD"}

\item{ignore_extension}{Boolean. If TRUE, the parser will try to read every
file in path regardless of the expected extension.}
}
\value{
a list containing a vector of paths called `i_path` and a char
        with the file format called `i_format`
}
\description{
Internal function to verify file paths and format
}
\author{
Jose Eduardo Meireles
}
\keyword{internal}
