% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandPass.R
\name{BP}
\alias{BP}
\title{Simple bandpass function}
\usage{
BP(f, fc, BW, n = 3)
}
\arguments{
\item{f}{vector of frequencies}

\item{fc}{center frequency}

\item{BW}{bandwidth, with \code{w[f < (fc - BW) | f > (fc+BW)] == 0}}

\item{n}{degree of the polynom, \code{n} can be real, e.g. \code{n = 2.5}}
}
\value{
This function returns a weight vector, which is to apply to the frequency
vector \code{f} in a top level function
}
\description{
This function represents a simple weighting function for spectral filtering.
}
\details{
The band pass is represented troughout a polynom in the form
\deqn{w = 1 - a * (f-fc)^n} with the degree \eqn{n}. The parameter \eqn{fc}
controlls the center frequency and \eqn{a} scales the required band width \code{BW}.
outside the band width the result is forced to zero.
}

