library(spdep)
data(oldcol)
lw <- nb2listw(COL.nb)
COL.OLD$fEW <- factor(COL.OLD$EW)
COL.OLD$fDISCBD <- ordered(cut(COL.OLD$DISCBD, c(0, 1.5, 3, 4.5, 6)))
f <- formula(CRIME ~ INC + HOVAL + fDISCBD*fEW)
lm_obj <- lm(f, data=COL.OLD)
expect_warning(COL.SD0 <- SD.RStests(lm_obj, lw, test="SDM", Durbin=TRUE))
expect_warning(COL.SD1 <- SD.RStests(lm_obj, lw, test="SDM", Durbin=~ INC + HOVAL + fDISCBD*fEW))
expect_warning(COL.SD2 <- SD.RStests(lm_obj, lw, test="SDM", Durbin=~ INC + HOVAL + fEW))
expect_silent(COL.SD3 <- SD.RStests(lm_obj, lw, test="SDM", Durbin=~ INC + HOVAL))
expect_warning(COL.SDE0 <- SD.RStests(lm_obj, lw, test="SDEM", Durbin=TRUE))
expect_warning(COL.SDE1 <- SD.RStests(lm_obj, lw, test="SDEM", Durbin=~ INC + HOVAL + fDISCBD*fEW))
expect_warning(COL.SDE2 <- SD.RStests(lm_obj, lw, test="SDEM", Durbin=~ INC + HOVAL + fEW))
expect_silent(COL.SDE3 <- SD.RStests(lm_obj, lw, test="SDEM", Durbin=~ INC + HOVAL))

