% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SPCA_Methods_For_Class.R
\name{plot.spca}
\alias{plot.spca}
\title{Plots loadings and variance explained for an spca object}
\usage{
\method{plot}{spca}(x, cols, plotvexp = TRUE, methodname = FALSE,
  plotload = FALSE, thresh = 0.001, perc = TRUE, variablesnames = FALSE,
  onlynonzero = TRUE, plotloadvsPC = FALSE, pcs = NULL,
  addlabels = TRUE, mfrowload = 1, mfcolload = 1, bnw = FALSE,
  rotlabels = 0, sizelabels = 1, ...)
}
\arguments{
\item{x}{An spca object.}

\item{cols}{The number of components to be plotted. Default all.  If an
iteger is passed, it is set to 1:cols.}

\item{plotvexp}{Logical: should the cumulative variance explained be
plotted?}

\item{methodname}{Name of the method. If FALSE set to LS SPCA}

\item{plotload}{Logical: should the loadings be plotted?}

\item{thresh}{Real: value below this are considered zero and not plotted. It
\emph{thresh}> 0.001 it is effective regardless of the value of \emph{onlynonzero}.}

\item{perc}{Logical: should the loading be scaled as percentages?}

\item{variablesnames}{names of the variables to use in plot of loadings.  If FALSE,
names are set to V1, V2,... If TRUE the rownames of the matrix of loadings
are used.}

\item{onlynonzero}{Logical: should only the non-zero loadings be plotted?}

\item{plotloadvsPC}{Logical: if TRUE the sparse loadings are plotted versus
the corresponding PCA ones.}

\item{pcs}{An spca object containing the PCA loadings, typically obtained
with the function pca.}

\item{addlabels}{Hybrid: if TRUE the nonzero loadings in the plotloadvsPC
and plotload plots are labelled with short names V1, V2,..., if equal to
"orig" the original variables names are used as labels, if FALSE no labels
are added.}

\item{mfrowload}{Number of loadings plots per row.}

\item{mfcolload}{Number of loadings plots per column.}

\item{bnw}{Logical: should the plots be in black and white?}

\item{rotlabels}{Angle for the rotation of the labels, see \emph{srt} in \code{\link[graphics]{par}}.}

\item{sizelabels}{Magnification of the labels, see \emph{cex} in \code{\link[graphics]{par}}.}

\item{...}{Additonal arguments for generic plot. Disabled, additional arguments will
generate an error.}
}
\value{
None
}
\description{
Plots coefficients and variance explained for spca solutions.
}
\details{
The cumulative variance explained is always plotted together with that
explained by the PCs.  The loadings are plotted as barplots. For large
matrices it is reccommended to set onlynonzero = TRUE and variablesnames = F. The
plots of the sparse loadings versus the PC's ones are marked with the line
of equality of the PCs ones.
}
\note{
The value of \emph{thresh} must be chosen according to the value of \emph{perc}.\cr
The "dots" are disabled so that only exact (or partial) prescribed arguments
can be entered.\cr
The plots are not very customisable. Personalised plots can be easily
produced from the spca object.
}
\seealso{
Examples in \code{\link{spcabe}} and \code{\link{spcabb}}. For plotting two or
more spca solutions together see \code{\link{compare}}.
}

