\name{anova.ppm}
\alias{anova.ppm}
\title{ANOVA for Fitted Point Process Models}
\description{
Performs analysis of deviance for two or more fitted point process models.
}
\usage{
  anova.ppm(object, \dots, test=NULL, override=FALSE)
}
\arguments{
  \item{object}{A fitted point process model
    (object of class \code{"ppm"}).
    }
    \item{\dots}{
      One or more fitted point process models.
    }
    \item{test}{
      Character string, partially matching one of
      \code{"Chisq"}, \code{"F"} or \code{"Cp"}.
    }
    \item{override}{
      Logical flag indicating whether to proceed even when there is
      no statistical theory to support the calculation.
    }
}
\value{
  An object of class \code{"anova"}, or \code{NULL}.
}
\details{
  This is a method for \code{\link{anova}} for 
  fitted point process models (objects of class \code{"ppm"},
  usually generated by the model-fitting function \code{\link{ppm}}).

  If the fitted models are all Poisson point processes,
  then this function performs an Analysis of Deviance of
  the fitted models. The output shows the deviance differences
  (i.e. 2 times log likelihood ratio),
  the difference in degrees of freedom, and (if \code{test="Chi"})
  the two-sided p-values for the chi-squared tests. Their interpretation
  is very similar to that in \code{\link{anova.glm}}.

  If some of the fitted models are \emph{not} Poisson point processes,
  then there is no statistical theory available to support
  a similar analysis. The function issues a warning,
  and (by default) returns a \code{NULL} value.

  However if \code{override=TRUE},
  then a kind of analysis of deviance table will be printed.
  The `deviance' differences in this table are equal to 2 times the differences
  in the maximised values of the log pseudolikelihood (see
  \code{\link{ppm}}). At the time of writing, there is no statistical
  theory to support inferential interpretation of log pseudolikelihood
  ratios. The \code{override} option is provided for research purposes
  only!
}
\seealso{
  \code{\link{ppm}}
}
\examples{
 data(swedishpines)
 mod0 <- ppm(swedishpines, ~1, Poisson())
 modx <- ppm(swedishpines, ~x, Poisson())
 anova.ppm(modx, mod0, test="Chi")
}
\author{Adrian Baddeley
  \email{adrian@maths.uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{rolf@math.unb.ca}
  \url{http://www.math.unb.ca/~rolf}
}
\keyword{spatial}
 
 
