### R code from vignette source 'updates.Rnw'

###################################################
### code chunk number 1: updates.Rnw:20-24
###################################################
library(spatstat)
sversion <- read.dcf(file = system.file("DESCRIPTION", package = "spatstat"),
         fields = "Version")
options(useFancyQuotes=FALSE)


###################################################
### code chunk number 2: updates.Rnw:41-66
###################################################
getSizeTable <- function(packagename="spatstat") {
  fname <- system.file("doc", "packagesizes.txt", package=packagename)
  if(!file.exists(fname)) 
    return(NULL)
  a <- read.table(fname, header=TRUE)
  a$date <- as.Date(a$date)
  return(a)
}
counts <- c("nhelpfiles", "nobjects", "ndatasets", "Rlines", "srclines")
mergeSizeTables <- function(a, b) {
  if(is.null(b)) return(a)
  for(i in seq_len(nrow(a))) {
    j <- which(b$date <= a$date[i])
    if(length(j) > 0) 
      a[i,counts] <- a[i,counts] + b[max(j), counts]
  }
  return(a)
}
z <- getSizeTable()
zutils <- getSizeTable("spatstat.utils")
z <- mergeSizeTables(z, zutils)
#
changes <- z[nrow(z), ] - z[z$version == "1.42-0", ]
newobj <- changes[["nobjects"]]
newdat <- changes[["ndatasets"]] + 1  # counting rule doesn't detect redwood3


###################################################
### code chunk number 3: updates.Rnw:76-81
###################################################
options(SweaveHooks=list(fig=function() par(mar=0.2+c(2,4,2,0))))
Plot <- function(fmla, ..., dat=z) {
  yvals <- eval(as.expression(fmla[[2]]), envir=dat)
  plot(fmla, ..., data=dat, type="l", xlab="", lwd=2, ylim=c(0, max(yvals)))
}


###################################################
### code chunk number 4: updates.Rnw:87-92
###################################################
getOption("SweaveHooks")[["fig"]]()
Plot((Rlines + srclines)/1000 ~ date, ylab="Lines of code (x 1000)", 
     main="Spatstat growth")
lines(srclines/1000 ~ date, data=z)
text(as.Date("2013-01-01"), 9.5, "C code")
text(as.Date("2013-01-01"), 50, "R code")


###################################################
### code chunk number 5: updates.Rnw:1654-1658
###################################################
nbugs <- nrow(news(grepl("^BUG", Category), 
                   package="spatstat"))
nbugssince <- nrow(news(Version > "1.42-0" & grepl("^BUG", Category), 
                   package="spatstat"))


###################################################
### code chunk number 6: updates.Rnw:1664-1665 (eval = FALSE)
###################################################
## news(grepl("^BUG", Category), package="spatstat")


